/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.deserializing;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.mule.module.apikit.api.deserializing.ArrayHeaderDelimiter;
import org.mule.module.apikit.deserializing.BaseAttributeDeserializer;

public class ArrayHeaderAttributeDeserializer
extends BaseAttributeDeserializer {
    private static final Set<Character> SPACE_CHARS = ImmutableSet.of((Object)Character.valueOf(' '), (Object)Character.valueOf('\n'), (Object)Character.valueOf('\t'), (Object)Character.valueOf('\r'), (Object)Character.valueOf('\f'));
    private ArrayHeaderDelimiter arrayHeaderDelimiter;

    public ArrayHeaderAttributeDeserializer(ArrayHeaderDelimiter arrayHeaderDelimiter) {
        this.arrayHeaderDelimiter = arrayHeaderDelimiter;
    }

    @Override
    public List<String> deserializeValue(String attributeValue) {
        char delimiter = this.arrayHeaderDelimiter.getDelimiterValue().charAt(0);
        char[] chars = attributeValue.toCharArray();
        ArrayList<String> values = new ArrayList<String>();
        int current = 0;
        while (current < chars.length) {
            if ((current = ArrayHeaderAttributeDeserializer.skipWhiteSpace(current, chars)) == chars.length) {
                values.add("");
                continue;
            }
            if (chars[current] == delimiter) {
                values.add("");
                if (++current != chars.length) continue;
                values.add("");
                continue;
            }
            if (chars[current] == '\"') {
                current = this.tryParseQuotedString(current, chars, delimiter, values);
                continue;
            }
            if (chars[current] == '{' || chars[current] == '[') {
                current = this.tryParseJsonObject(current, chars, delimiter, values);
                continue;
            }
            current = this.tryParseRawString(current, chars, delimiter, values);
        }
        return values;
    }

    private static int skipWhiteSpace(int start, char[] chars) {
        int current;
        for (current = start; current < chars.length && SPACE_CHARS.contains(Character.valueOf(chars[current])); ++current) {
        }
        return current;
    }

    private int tryParseQuotedString(int start, char[] chars, char delimiter, List<String> values) {
        int current;
        StringBuffer curVal = new StringBuffer();
        for (current = start + 1; current < chars.length && chars[current] != '\"'; ++current) {
            if (chars[current] == '\\' && current < chars.length - 1 && chars[current + 1] == '\"') {
                ++current;
            }
            curVal.append(chars[current]);
        }
        ++current;
        if ((current = ArrayHeaderAttributeDeserializer.skipWhiteSpace(current, chars)) == chars.length || chars[current] == delimiter) {
            values.add(curVal.toString());
            return current + 1;
        }
        return this.tryParseRawString(start, chars, delimiter, values);
    }

    private int tryParseJsonObject(int start, char[] chars, char delimiter, List<String> values) {
        StringBuffer curVal = new StringBuffer();
        int current = start;
        Stack<Character> stack = new Stack<Character>();
        do {
            Character top;
            if (chars[current] == '\"') {
                do {
                    if (chars[current] == '\\') {
                        curVal.append(chars[current]);
                        ++current;
                    }
                    if (current >= chars.length) continue;
                    curVal.append(chars[current]);
                    ++current;
                } while (current < chars.length && chars[current] != '\"');
            } else if (chars[current] == '}') {
                top = (Character)stack.pop();
                if (top.charValue() != '{') {
                    return this.tryParseRawString(start, chars, delimiter, values);
                }
            } else if (chars[current] == ']') {
                top = (Character)stack.pop();
                if (top.charValue() != '[') {
                    return this.tryParseRawString(start, chars, delimiter, values);
                }
            } else if (chars[current] == '[' || chars[current] == '{') {
                stack.push(Character.valueOf(chars[current]));
            }
            if (current >= chars.length) continue;
            curVal.append(chars[current]);
            ++current;
        } while (current < chars.length && !stack.isEmpty());
        if ((current = ArrayHeaderAttributeDeserializer.skipWhiteSpace(current, chars)) == chars.length || chars[current] == delimiter) {
            values.add(curVal.toString());
            return current + 1;
        }
        return this.tryParseRawString(start, chars, delimiter, values);
    }

    private int tryParseRawString(int start, char[] chars, char delimiter, List<String> values) {
        int current = start;
        int indexFirstNonWhitespace = current = ArrayHeaderAttributeDeserializer.skipWhiteSpace(current, chars);
        int indexLastNonWhitespace = current;
        while (current < chars.length && chars[current] != delimiter) {
            if (!SPACE_CHARS.contains(Character.valueOf(chars[current]))) {
                indexLastNonWhitespace = current;
            }
            ++current;
        }
        values.add(new String(chars, indexFirstNonWhitespace, indexLastNonWhitespace - indexFirstNonWhitespace + 1));
        return current + 1;
    }
}

