/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.config.ConfigurationState;
import org.mule.runtime.extension.api.runtime.config.ConfiguredComponent;
import org.mule.runtime.extension.api.runtime.source.ParameterizedSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageSourceUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageSourceUtils.class);

    public static URI getUriFromFlow(Component source) {
        if (source != null && MessageSourceUtils.isHttpExtensionSource(source)) {
            try {
                String resolvedPath = MessageSourceUtils.getListenerPath(source);
                return MessageSourceUtils.buildListenerUri(MessageSourceUtils.getConfigState(source).getConnectionParameters(), resolvedPath);
            }
            catch (Exception e) {
                LOGGER.warn("Error getting uri from flow " + source.getLocation().getRootContainerName(), (Throwable)e);
            }
        }
        return null;
    }

    private static String getListenerPath(Component source) {
        ParameterizedSource parameterizedSource = (ParameterizedSource)source;
        String listenerPath = (String)parameterizedSource.getInitialisationParameters().get("path");
        String basePath = (String)MessageSourceUtils.getConfigState(source).getConfigParameters().get("basePath");
        listenerPath = StringUtils.prependIfMissing((String)listenerPath, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        return basePath == null ? listenerPath : StringUtils.prependIfMissing((String)basePath, (CharSequence)"/", (CharSequence[])new CharSequence[0]) + listenerPath;
    }

    private static ConfigurationState getConfigState(Component source) {
        ConfiguredComponent configuredComponent = (ConfiguredComponent)source;
        return ((ConfigurationInstance)configuredComponent.getConfigurationInstance().orElseThrow(() -> new RuntimeException("Source does not contain a configuration instance"))).getState();
    }

    private static boolean isHttpExtensionSource(Component source) {
        ComponentIdentifier identifier = source.getLocation().getComponentIdentifier().getIdentifier();
        return identifier.equals(ComponentIdentifier.buildFromStringRepresentation((String)"http:listener"));
    }

    private static URI buildListenerUri(Map<String, Object> connectionParams, String path) throws URISyntaxException {
        String host = (String)connectionParams.get("host");
        Integer port = (Integer)connectionParams.get("port");
        String scheme = connectionParams.get("protocol").toString().toLowerCase();
        return new URI(scheme, null, host, port, path, null, null);
    }
}

