/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit;

import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.URI;
import java.util.Map;
import java.util.Optional;
import java.util.zip.GZIPOutputStream;
import javax.inject.Inject;
import org.mule.apikit.ApiType;
import org.mule.extension.http.api.HttpRequestAttributes;
import org.mule.module.apikit.ApikitErrorTypes;
import org.mule.module.apikit.ApikitRegistry;
import org.mule.module.apikit.Configuration;
import org.mule.module.apikit.api.FlowUtils;
import org.mule.module.apikit.api.UrlUtils;
import org.mule.module.apikit.api.console.ConsoleResources;
import org.mule.module.apikit.api.console.Resource;
import org.mule.module.apikit.exception.NotFoundException;
import org.mule.module.apikit.helpers.AttributesHelper;
import org.mule.module.apikit.helpers.ConfigURLMapping;
import org.mule.module.apikit.helpers.EventHelper;
import org.mule.module.apikit.helpers.EventWrapper;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.core.api.util.StringMessageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Console
extends AbstractComponent
implements Processor,
Initialisable,
Disposable {
    private final ApikitRegistry registry;
    private final ConfigurationComponentLocator locator;
    private Configuration configuration;
    private String name;
    protected static final Logger logger = LoggerFactory.getLogger(Console.class);
    private static final String CONSOLE_URL_FILE = "consoleurl";
    private static final String CONSOLE_DISABLED = "apikit.console.disabled";
    private boolean consoleDisabled;
    private boolean streamAMFModel;
    private static final String STREAM_AMF_MODEL = "apikit.console.stream.amf.model";
    @Inject
    private MuleContext muleContext;
    @Inject
    private SchedulerService schedulerService;
    private Scheduler scheduler;

    @Inject
    public Console(ApikitRegistry registry, ConfigurationComponentLocator locator) {
        this.registry = registry;
        this.locator = locator;
    }

    public void initialise() {
        this.consoleDisabled = Boolean.valueOf(System.getProperty(CONSOLE_DISABLED, "false"));
        this.streamAMFModel = Boolean.valueOf(System.getProperty(STREAM_AMF_MODEL, "true"));
        String name = this.getLocation().getRootContainerName();
        Optional<URI> url = FlowUtils.getSourceLocation(this.locator, name);
        if (url.isPresent()) {
            URI uri = url.get();
            String consoleUrl = uri.toString().replace("*", "");
            String consoleUrlFixed = UrlUtils.getBaseUriReplacement(consoleUrl);
            logger.info(StringMessageUtils.getBoilerPlate((String)("APIKit Console URL: " + consoleUrlFixed)));
            this.publishConsoleUrls(consoleUrlFixed);
        } else {
            logger.error("There was an error retrieving console source.");
        }
        this.scheduler = this.getScheduler();
    }

    public CoreEvent process(CoreEvent event) {
        if (this.consoleDisabled) {
            throw ApikitErrorTypes.throwErrorType(new NotFoundException("Not Found"), ApikitErrorTypes.errorRepositoryFrom(this.muleContext));
        }
        Configuration config = this.getConfiguration();
        EventWrapper eventWrapper = new EventWrapper(event, config.getOutboundHeadersMapName(), config.getHttpStatusVarName());
        HttpRequestAttributes attributes = EventHelper.getHttpRequestAttributes(event);
        String listenerPath = attributes.getListenerPath();
        String requestPath = attributes.getRequestPath();
        String acceptHeader = AttributesHelper.getAcceptedResponseMediaTypes((MultiMap<String, String>)attributes.getHeaders());
        String queryString = attributes.getQueryString();
        String method = attributes.getMethod();
        String host = (String)attributes.getHeaders().get((Object)"host");
        ConsoleResources consoleResources = new ConsoleResources(config, listenerPath, requestPath, queryString, method, acceptHeader, ApikitErrorTypes.errorRepositoryFrom(this.muleContext), UrlUtils.replaceHostInURL(ConfigURLMapping.INSTANCE.getUrl(config.getName()), host));
        consoleResources.isValidPath(attributes.getListenerPath());
        String consoleBasePath = UrlUtils.getBasePath(listenerPath, requestPath);
        String resourceRelativePath = UrlUtils.getRelativePath(listenerPath, requestPath);
        if (!consoleBasePath.endsWith("/")) {
            eventWrapper.doClientRedirect();
            return eventWrapper.build();
        }
        Resource resource = this.streamAMFModel && ApiType.AMF.equals((Object)config.getType()) && "amf".equals(queryString) ? this.streamAMFModel(UrlUtils.replaceHostInURL(ConfigURLMapping.INSTANCE.getUrl(config.getName()), host)) : consoleResources.getConsoleResource(resourceRelativePath);
        eventWrapper.setPayload(resource.getContent() == null ? "" : resource.getContent(), resource.getMediaType());
        eventWrapper.addOutboundProperties((Map<String, String>)resource.getHeaders());
        return eventWrapper.build();
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishConsoleUrls(String consoleUrl) {
        FileWriter writer = null;
        try {
            String parentDirectory = this.muleContext.getConfiguration().getWorkingDirectory();
            File urlFile = new File(parentDirectory, CONSOLE_URL_FILE);
            if (!urlFile.exists()) {
                urlFile.createNewFile();
            }
            writer = new FileWriter(urlFile, true);
            writer.write(consoleUrl + "\n");
            writer.flush();
            IOUtils.closeQuietly((Closeable)writer);
        }
        catch (Exception e) {
            logger.error("cannot publish console url for studio", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly(writer);
        }
    }

    private Resource streamAMFModel(String url) {
        try {
            PipedOutputStream pipedOutputStream = new PipedOutputStream();
            final PipedInputStream responsePayload = new PipedInputStream(pipedOutputStream);
            this.scheduler.execute(() -> {
                try {
                    this.configuration.getRamlHandler().writeAMFModel(url, new GZIPOutputStream(pipedOutputStream));
                }
                catch (Exception e) {
                    logger.error("Error trying to stream AMF Model");
                }
            });
            return new Resource(){

                @Override
                public MediaType getMediaType() {
                    return MediaType.APPLICATION_JSON;
                }

                @Override
                public Object getContent() {
                    return responsePayload;
                }

                @Override
                public MultiMap<String, String> getHeaders() {
                    MultiMap headers = new MultiMap();
                    headers.put((Object)"Content-Encoding", (Object)"gzip");
                    return headers;
                }
            };
        }
        catch (IOException e) {
            return null;
        }
    }

    public void dispose() {
        this.scheduler.shutdownNow();
    }

    private Scheduler getScheduler() {
        SchedulerConfig config = SchedulerConfig.config().withName("CONSOLE-SCHEDULER");
        return this.schedulerService.ioScheduler(config);
    }
}

