/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.input.stream;

import java.io.IOException;
import java.io.InputStream;
import org.mule.module.apikit.input.stream.Rewindable;

public class RewindableInputStream
extends InputStream
implements Rewindable {
    private Block head;
    private int curBlockAvail;
    private Block curBlock;
    private int curBlockPos;
    private Block lastBlock;
    private boolean saving = true;
    private final InputStream in;
    private boolean pretendClosed = false;
    private boolean eof;

    public RewindableInputStream(InputStream in) {
        if (in == null) {
            throw new NullPointerException();
        }
        this.in = in;
    }

    @Override
    public void close() throws IOException {
        if (this.saving) {
            this.curBlockAvail = 0;
            this.curBlock = null;
            this.pretendClosed = true;
        } else {
            this.head = null;
            this.curBlock = null;
            this.lastBlock = null;
            this.saving = false;
            this.curBlockAvail = 0;
            this.in.close();
        }
    }

    @Override
    public void rewind() {
        if (!this.saving) {
            throw new IllegalStateException("rewind() after willNotRewind()");
        }
        this.pretendClosed = false;
        if (this.head == null) {
            return;
        }
        this.curBlock = this.head;
        this.curBlockPos = 0;
        this.curBlockAvail = this.curBlock.used;
    }

    @Override
    public boolean canRewind() {
        return this.saving;
    }

    @Override
    public void willNotRewind() {
        this.saving = false;
        this.head = null;
        this.lastBlock = null;
        if (this.pretendClosed) {
            this.pretendClosed = false;
            try {
                this.in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public int read() throws IOException {
        if (this.curBlockAvail > 0) {
            int blockIndex = this.curBlock.buf[this.curBlockPos++] & 0xFF;
            --this.curBlockAvail;
            if (this.curBlockAvail == 0) {
                this.curBlock = this.curBlock.next;
                if (this.curBlock != null) {
                    this.curBlockPos = 0;
                    this.curBlockAvail = this.curBlock.used;
                }
            }
            return blockIndex;
        }
        int c = this.in.read();
        if (this.saving && c != -1) {
            if (this.lastBlock == null) {
                this.lastBlock = this.head = new Block();
            } else if (this.lastBlock.used == this.lastBlock.buf.length) {
                this.lastBlock = this.lastBlock.next = new Block();
            }
            this.lastBlock.append((byte)c);
        }
        return c;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int nRead;
        block16: {
            if (this.curBlockAvail == 0 && !this.saving) {
                return this.in.read(b, off, len);
            }
            if (b == null) {
                throw new NullPointerException();
            }
            if (len < 0) {
                throw new IndexOutOfBoundsException();
            }
            nRead = 0;
            if (this.curBlockAvail != 0) {
                while (true) {
                    if (len == 0) {
                        return nRead;
                    }
                    b[off++] = this.curBlock.buf[this.curBlockPos++];
                    --len;
                    ++nRead;
                    --this.curBlockAvail;
                    if (this.curBlockAvail != 0) continue;
                    this.curBlock = this.curBlock.next;
                    if (this.curBlock == null) break;
                    this.curBlockAvail = this.curBlock.used;
                    this.curBlockPos = 0;
                }
            }
            if (len == 0) {
                return nRead;
            }
            if (this.eof) {
                return nRead > 0 ? nRead : -1;
            }
            try {
                int n = this.in.read(b, off, len);
                if (n < 0) {
                    this.eof = true;
                    return nRead > 0 ? nRead : -1;
                }
                nRead += n;
                if (this.saving) {
                    if (this.lastBlock == null) {
                        this.lastBlock = this.head = new Block(n);
                    } else if (this.lastBlock.buf.length - this.lastBlock.used < n) {
                        if (this.lastBlock.used != this.lastBlock.buf.length) {
                            int free = this.lastBlock.buf.length - this.lastBlock.used;
                            this.lastBlock.append(b, off, free);
                            off += free;
                            n -= free;
                        }
                        this.lastBlock = this.lastBlock.next = new Block(n);
                    }
                    this.lastBlock.append(b, off, n);
                }
            }
            catch (IOException e) {
                this.eof = true;
                if (nRead != 0) break block16;
                throw e;
            }
        }
        return nRead;
    }

    @Override
    public int available() throws IOException {
        if (this.curBlockAvail == 0) {
            return this.in.available();
        }
        int n = this.curBlockAvail;
        Block b = this.curBlock.next;
        while (b != null) {
            n += b.used;
            b = b.next;
        }
        return n + this.in.available();
    }

    static class Block {
        Block next;
        final byte[] buf;
        int used = 0;
        static final int MIN_SIZE = 1024;

        Block(int minSize) {
            this.buf = new byte[Math.max(1024, minSize)];
        }

        Block() {
            this(0);
        }

        void append(byte b) {
            this.buf[this.used++] = b;
        }

        void append(byte[] b, int off, int len) {
            System.arraycopy(b, off, this.buf, this.used, len);
            this.used += len;
        }
    }
}

