/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.deserializing;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class MimeType {
    private String type;
    private String subtype;
    private final List<Parameter> parameters;

    public static MimeType from(String mimeType) throws MimeTypeParseException {
        Parser parser = new Parser(mimeType);
        MimeType mime = parser.nextMimeType();
        parser.assertAtEnd();
        return mime;
    }

    public static List<MimeType> listFrom(String mimeTypeList, char listDelimiter) throws MimeTypeParseException {
        Parser parser = new Parser(mimeTypeList);
        List mimes = parser.nextMimeTypeList(listDelimiter);
        parser.assertAtEnd();
        return mimes;
    }

    private MimeType() {
        this.parameters = new ArrayList<Parameter>();
    }

    public MimeType(String type, String subtype, List<Parameter> parameters) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(subtype);
        Objects.requireNonNull(parameters);
        this.type = type;
        this.subtype = subtype;
        this.parameters = parameters;
    }

    public String getType() {
        return this.type;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MimeType mimeType = (MimeType)o;
        return this.type.equals(mimeType.type) && this.subtype.equals(mimeType.subtype) && this.parameters.equals(mimeType.parameters);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.subtype);
    }

    public String toString() {
        String parameterList = this.parameters.stream().map(param -> "; " + param).collect(Collectors.joining());
        return this.type + '/' + this.subtype + parameterList;
    }

    public static class MimeTypeParseException
    extends Exception {
        private MimeTypeParseException(String message) {
            super(message);
        }
    }

    public static class Parser {
        private int i = 0;
        private final CharSequence input;

        public Parser(CharSequence input) {
            this.input = input;
        }

        private List<MimeType> nextMimeTypeList(char listDelimiter) throws MimeTypeParseException {
            ArrayList<MimeType> mimes = new ArrayList<MimeType>();
            do {
                mimes.add(this.nextMimeType());
            } while (this.trySkip(listDelimiter));
            return mimes;
        }

        private MimeType nextMimeType() throws MimeTypeParseException {
            MimeType mime = new MimeType();
            this.skipWhitespace();
            mime.type = this.nextToken();
            this.skipWhitespace();
            boolean hasSubtype = this.trySkip('/');
            if (hasSubtype) {
                this.skipWhitespace();
                mime.subtype = this.nextToken();
            } else {
                mime.subtype = "*";
            }
            this.skipWhitespace();
            if (!this.atEnd() && this.trySkip(';')) {
                mime.parameters.addAll(this.nextParameterList());
            }
            this.skipWhitespace();
            return mime;
        }

        private Parameter nextParameter() throws MimeTypeParseException {
            this.skipWhitespace();
            String attribute = this.nextToken();
            this.skipWhitespace();
            this.skip('=');
            this.skipWhitespace();
            this.assertNotAtEnd();
            String value = this.peek() == '\"' ? this.nextQuotedString() : this.nextToken();
            this.skipWhitespace();
            return new Parameter(attribute, value);
        }

        private List<Parameter> nextParameterList() throws MimeTypeParseException {
            ArrayList<Parameter> parameter = new ArrayList<Parameter>();
            do {
                parameter.add(this.nextParameter());
            } while (!this.atEnd() && this.trySkip(';'));
            return parameter;
        }

        private String nextToken() throws MimeTypeParseException {
            this.assertNotAtEnd();
            int start = this.i;
            while (!this.atEnd() && Parser.isTokenChar(this.peek())) {
                this.skip();
            }
            if (start == this.i) {
                throw new MimeTypeParseException("Expected token at column " + (this.i + 1) + " but got `" + this.peek() + "`");
            }
            return this.input.subSequence(start, this.i).toString();
        }

        private String nextQuotedString() throws MimeTypeParseException {
            this.skip('\"');
            StringBuilder s = new StringBuilder();
            while (!this.atEnd() && Parser.isValidStringChar(this.input, this.i)) {
                if (this.peek() == '\\') {
                    this.skip();
                }
                this.assertNotAtEnd();
                s.append(this.peek());
                this.skip();
            }
            this.skip('\"');
            return s.toString();
        }

        private boolean trySkip(char expected) {
            if (this.atEnd() || this.peek() != expected) {
                return false;
            }
            this.skip();
            return true;
        }

        private void skip(char expected) throws MimeTypeParseException {
            this.assertNotAtEnd();
            char got = this.peek();
            if (got != expected) {
                throw new MimeTypeParseException("Expected " + expected + " at column " + (this.i + 1) + " but got `" + got + "`");
            }
            this.skip();
        }

        private void skipWhitespace() {
            while (!this.atEnd() && Character.isSpaceChar(this.peek())) {
                this.skip();
            }
        }

        private void skip() {
            ++this.i;
        }

        private char peek() {
            return this.input.charAt(this.i);
        }

        private boolean atEnd() {
            return this.input.length() <= this.i;
        }

        private void assertAtEnd() throws MimeTypeParseException {
            if (!this.atEnd()) {
                throw new MimeTypeParseException("Trailing non-whitespace text at column " + (this.i + 1));
            }
        }

        private void assertNotAtEnd() throws MimeTypeParseException {
            if (this.atEnd()) {
                throw new MimeTypeParseException("Unexpected end of input");
            }
        }

        private static boolean isTokenChar(char c) {
            return c != ' ' && !Parser.isCtl(c) && !Parser.isTspecial(c);
        }

        private static boolean isCtl(char c) {
            return '\u0000' <= c && c <= '\u001f' || c == '\u007f';
        }

        private static boolean isTspecial(char c) {
            return c == '(' || c == ')' || c == '<' || c == '>' || c == '@' || c == ',' || c == ';' || c == ':' || c == '\\' || c == '\"' || c == '/' || c == '[' || c == ']' || c == '?' || c == '=';
        }

        private static boolean isValidStringChar(CharSequence input, int i) {
            char c = input.charAt(i);
            return Parser.isQdtext(c) || Parser.isQuotedPair(input, i) || Parser.isObsText(c);
        }

        private static boolean isQdtext(char c) {
            return c == '\t' || c == ' ' || c == '!' || '#' <= c && c <= '[' || ']' <= c && c <= '~';
        }

        private static boolean isQuotedPair(CharSequence input, int i) {
            if (input.charAt(i) == '\\' && i + 1 < input.length()) {
                char c = input.charAt(i + 1);
                return c == '\t' || c == ' ' || Parser.isVchar(c) || Parser.isObsText(c);
            }
            return false;
        }

        private static boolean isObsText(char c) {
            return '\u0080' <= c;
        }

        private static boolean isVchar(char c) {
            return '!' < c && c < '~';
        }
    }

    public static class Parameter {
        private final String attribute;
        private final String value;

        public Parameter(String attribute, String value) {
            Objects.requireNonNull(attribute);
            Objects.requireNonNull(value);
            this.attribute = attribute;
            this.value = value;
        }

        public String getAttribute() {
            return this.attribute;
        }

        public String getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Parameter parameter = (Parameter)o;
            return this.attribute.equals(parameter.attribute) && this.value.equals(parameter.value);
        }

        public int hashCode() {
            return Objects.hash(this.attribute, this.value);
        }

        public String toString() {
            if (this.value.chars().allMatch(c -> Parser.isTokenChar((char)c))) {
                return this.attribute + '=' + this.value;
            }
            return this.attribute + "=\"" + this.escape(this.value) + "\"";
        }

        private String escape(String value) {
            return value.chars().flatMap(c -> Parser.isQdtext((char)c) || Parser.isObsText((char)c) ? IntStream.of(c) : ("\\" + (char)c).chars()).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
        }
    }
}

