/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.helpers;

import java.util.Optional;
import org.mule.apikit.ApiType;
import org.mule.module.apikit.api.RamlHandler;
import org.mule.module.apikit.helpers.APISpecModelHandler;

public class APISpecModelHandlerImpl
implements APISpecModelHandler {
    private final RamlHandler ramlHandler;
    private final String listenerPath;
    private final String requestPath;
    private final String queryString;
    private final String method;
    private final String acceptHeader;
    private final ApiType apiType;
    private final String resourceRelativePath;

    public APISpecModelHandlerImpl(RamlHandler ramlHandler, String listenerPath, String requestPath, String queryString, String method, String acceptHeader, ApiType apiType, String resourceRelativePath) {
        this.ramlHandler = ramlHandler;
        this.listenerPath = listenerPath;
        this.requestPath = requestPath;
        this.queryString = queryString;
        this.method = method;
        this.acceptHeader = acceptHeader;
        this.apiType = apiType;
        this.resourceRelativePath = resourceRelativePath;
    }

    @Override
    public synchronized Optional<String> getModel(String hostURL) {
        if (this.queryString.equals("api")) {
            return Optional.ofNullable(this.ramlHandler.dumpRaml());
        }
        if (this.ramlHandler.isRequestingRamlV1ForConsole(this.listenerPath, this.requestPath, this.queryString, this.method, this.acceptHeader)) {
            this.setApiServer(hostURL);
            return Optional.ofNullable(this.ramlHandler.getRamlV1());
        }
        if (this.ramlHandler.isRequestingRamlV2(this.listenerPath, this.requestPath, this.queryString, this.method)) {
            this.setApiServer(hostURL);
            return Optional.ofNullable(this.ramlHandler.getRamlV2(this.resourceRelativePath));
        }
        if (ApiType.AMF.equals((Object)this.apiType) && "amf".equals(this.queryString)) {
            this.setApiServer(hostURL);
            return Optional.ofNullable(this.ramlHandler.getAMFModel());
        }
        return Optional.empty();
    }

    private void setApiServer(String hostURL) {
        if (hostURL != null) {
            this.ramlHandler.setApiServer(hostURL);
        }
    }
}

