/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit;

import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.inject.Inject;
import org.mule.extension.http.api.HttpRequestAttributes;
import org.mule.module.apikit.ApikitErrorTypes;
import org.mule.module.apikit.ApikitRegistry;
import org.mule.module.apikit.CharsetUtils;
import org.mule.module.apikit.Configuration;
import org.mule.module.apikit.MessageSourceUtils;
import org.mule.module.apikit.api.UrlUtils;
import org.mule.module.apikit.api.config.ValidationConfig;
import org.mule.module.apikit.api.exception.BadRequestException;
import org.mule.module.apikit.api.exception.MuleRestException;
import org.mule.module.apikit.api.uri.ResolvedVariables;
import org.mule.module.apikit.api.uri.URIPattern;
import org.mule.module.apikit.api.uri.URIResolver;
import org.mule.module.apikit.api.validation.RequestValidator;
import org.mule.module.apikit.api.validation.ValidRequest;
import org.mule.module.apikit.exception.MethodNotAllowedException;
import org.mule.module.apikit.exception.NotFoundException;
import org.mule.module.apikit.helpers.AttributesHelper;
import org.mule.module.apikit.helpers.EventHelper;
import org.mule.module.apikit.input.stream.RewindableInputStream;
import org.mule.module.apikit.uri.URIResolveResult;
import org.mule.raml.interfaces.model.IResource;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.execution.ComponentExecutionException;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.exception.TypedException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class Router
extends AbstractComponent
implements Processor,
Initialisable {
    private final ApikitRegistry registry;
    private final ConfigurationComponentLocator locator;
    private Configuration configuration;
    private String name;
    private static final Logger LOGGER = LoggerFactory.getLogger(Router.class);

    @Inject
    public Router(ApikitRegistry registry, ConfigurationComponentLocator locator) {
        this.registry = registry;
        this.locator = locator;
    }

    public void initialise() throws InitialisationException {
        String name = this.getLocation().getRootContainerName();
        Optional<URI> url = this.locator.find(Location.builder().globalName(name).addSourcePart().build()).map(MessageSourceUtils::getUriFromFlow);
        if (!url.isPresent()) {
            LOGGER.error("There was an error retrieving api source. Console will work only if the keepRamlBaseUri property is set to true.");
            return;
        }
        this.registry.setApiSource(this.configuration.getName(), url.get().toString().replace("*", ""));
    }

    public CoreEvent process(CoreEvent event) throws MuleException {
        return MessageProcessors.processToApply((CoreEvent)event, (ReactiveProcessor)this);
    }

    public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
        return MessageProcessors.flatMap(publisher, event -> {
            try {
                Configuration config = this.registry.getConfiguration(this.getConfiguration().getName());
                CoreEvent.Builder eventBuilder = CoreEvent.builder((CoreEvent)event);
                eventBuilder.addVariable(config.getOutboundHeadersMapName(), new HashMap());
                HttpRequestAttributes attributes = (HttpRequestAttributes)event.getMessage().getAttributes().getValue();
                CompletableFuture<Event> resultEvent = this.doRoute((CoreEvent)event, config, eventBuilder, attributes);
                return Mono.fromFuture(resultEvent).cast(CoreEvent.class).onErrorMap(this::buildMuleException);
            }
            catch (MuleRestException e) {
                return Mono.error((Throwable)ApikitErrorTypes.throwErrorType(e));
            }
        }, (Component)this);
    }

    private Throwable buildMuleException(Throwable e) {
        if (e instanceof ComponentExecutionException) {
            return new TypedException(e.getCause(), ((Error)((ComponentExecutionException)e).getEvent().getError().get()).getErrorType());
        }
        if (e instanceof MuleException || e instanceof MuleRuntimeException) {
            return e;
        }
        return new DefaultMuleException(e);
    }

    private CompletableFuture<Event> doRoute(CoreEvent event, Configuration config, CoreEvent.Builder eventBuilder, HttpRequestAttributes attributes) throws MuleRestException {
        String path = UrlUtils.getRelativePath(attributes.getListenerPath(), attributes.getRequestPath());
        path = path.isEmpty() ? "/" : path;
        URIPattern uriPattern = this.findInCache(path, config.getUriPatternCache());
        URIResolver uriResolver = this.findInCache(path, config.getUriResolverCache());
        URIResolveResult resolvedVariables = uriResolver.resolve(uriPattern);
        IResource resource = this.getResource(config, attributes.getMethod().toLowerCase(), uriPattern);
        if (!config.isDisableValidations()) {
            eventBuilder = this.validateRequest(event, eventBuilder, config, resource, attributes, resolvedVariables);
        }
        String contentType = AttributesHelper.getMediaType(attributes);
        Flow flow = config.getFlowFinder().getFlow(resource, attributes.getMethod().toLowerCase(), contentType);
        String successStatusCode = config.getRamlHandler().getSuccessStatusCode(resource.getAction(attributes.getMethod().toLowerCase()));
        eventBuilder.addVariable(config.getHttpStatusVarName(), (Object)successStatusCode);
        return flow.execute((Event)eventBuilder.build());
    }

    private <T> T findInCache(String key, LoadingCache<String, T> cache) {
        try {
            return (T)cache.get((Object)key);
        }
        catch (Exception e) {
            throw ApikitErrorTypes.throwErrorType(new NotFoundException(key));
        }
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration config) {
        this.configuration = config;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CoreEvent.Builder validateRequest(CoreEvent event, CoreEvent.Builder eventBuilder, ValidationConfig config, IResource resource, HttpRequestAttributes attributes, ResolvedVariables resolvedVariables) throws MuleRestException {
        String charset;
        TypedValue payload = event.getMessage().getPayload();
        try {
            Object payloadValue = payload.getValue();
            if (payloadValue instanceof InputStream) {
                RewindableInputStream rewindable = new RewindableInputStream((InputStream)payloadValue);
                charset = CharsetUtils.getEncoding(event.getMessage(), rewindable, LOGGER);
                rewindable.rewind();
                payload = new TypedValue((Object)rewindable, payload.getDataType());
            } else {
                charset = CharsetUtils.getEncoding(event.getMessage(), payloadValue, LOGGER);
            }
        }
        catch (IOException e) {
            throw ApikitErrorTypes.throwErrorType(new BadRequestException("Error processing request: " + e.getMessage()));
        }
        ValidRequest validRequest = RequestValidator.validate(config, resource, attributes, resolvedVariables, payload, charset);
        return EventHelper.regenerateEvent(event.getMessage(), eventBuilder, validRequest);
    }

    private IResource getResource(Configuration configuration, String method, URIPattern uriPattern) throws TypedException {
        IResource resource = configuration.getFlowFinder().getResource(uriPattern);
        if (resource.getAction(method) == null) {
            throw ApikitErrorTypes.throwErrorType(new MethodNotAllowedException(resource.getResolvedUri(configuration.getRamlHandler().getApi().getVersion()) + " : " + method));
        }
        return resource;
    }
}

