/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation.body.schema.v1.io;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsonschema.JsonSchema;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.ExecutionException;
import org.springframework.core.io.AbstractFileResolvingResource;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class JsonSchemaResource
extends AbstractFileResolvingResource {
    private String className;
    private ClassLoader classLoader;
    private static LoadingCache<Class<?>, byte[]> schemaCache = CacheBuilder.newBuilder().maximumSize(1000L).build(new CacheLoader<Class<?>, byte[]>(){
        private ObjectMapper objectMapper;

        public byte[] load(Class<?> clazz) throws IOException {
            if (this.objectMapper == null) {
                this.objectMapper = new ObjectMapper().disableDefaultTyping();
            }
            JsonSchema jsonSchema = this.objectMapper.generateJsonSchema(clazz);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.objectMapper.writeValue((OutputStream)baos, (Object)jsonSchema);
            return baos.toByteArray();
        }
    });

    public JsonSchemaResource(String className, ClassLoader classLoader) {
        Assert.notNull((Object)className, (String)"Class name must not be null");
        this.className = className;
        this.classLoader = classLoader != null ? classLoader : ClassUtils.getDefaultClassLoader();
    }

    public String getDescription() {
        StringBuilder builder = new StringBuilder("annotated class resource [");
        builder.append(this.className);
        builder.append(']');
        return builder.toString();
    }

    public InputStream getInputStream() throws IOException {
        try {
            Class<?> clazz = this.classLoader.loadClass(this.className);
            return new ByteArrayInputStream((byte[])schemaCache.get(clazz));
        }
        catch (ClassNotFoundException e) {
            throw new IOException(this.getDescription() + " cannot be found", e);
        }
        catch (ExecutionException e) {
            throw new IOException(this.getDescription() + " cannot be found", e.getCause());
        }
    }
}

