/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.api;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.mule.module.apikit.ApikitErrorTypes;
import org.mule.module.apikit.StreamUtils;
import org.mule.module.apikit.api.UrlUtils;
import org.mule.module.apikit.exception.NotFoundException;
import org.mule.module.apikit.parser.ParserService;
import org.mule.raml.interfaces.model.IAction;
import org.mule.raml.interfaces.model.IRaml;
import org.mule.runtime.api.exception.TypedException;
import org.mule.runtime.core.api.MuleContext;
import org.raml.model.ActionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RamlHandler {
    public static final String APPLICATION_RAML = "application/raml+yaml";
    private static final String RAML_QUERY_STRING = "raml";
    private boolean keepRamlBaseUri;
    private String apiServer;
    private IRaml api;
    private ParserService parserService;
    private String apiResourcesRelativePath = "";
    protected static final Logger logger = LoggerFactory.getLogger(RamlHandler.class);
    private MuleContext muleContext;

    public RamlHandler(String ramlLocation, boolean keepRamlBaseUri, MuleContext muleContext) throws IOException {
        this.keepRamlBaseUri = keepRamlBaseUri;
        String rootRamlLocation = this.findRootRaml(ramlLocation);
        if (rootRamlLocation == null) {
            throw new IOException("Raml not found at: " + ramlLocation);
        }
        this.parserService = new ParserService(rootRamlLocation);
        this.parserService.validateRaml();
        this.api = this.parserService.build();
        int idx = rootRamlLocation.lastIndexOf("/");
        if (idx > 0) {
            this.apiResourcesRelativePath = rootRamlLocation.substring(0, idx + 1);
            this.apiResourcesRelativePath = this.sanitarizeResourceRelativePath(this.apiResourcesRelativePath);
        }
        this.muleContext = muleContext;
    }

    public boolean isParserV2() {
        return this.parserService.isParserV2();
    }

    public IRaml getApi() {
        return this.api;
    }

    public void setApi(IRaml api) {
        this.api = api;
    }

    public String getRamlV1() {
        if (this.keepRamlBaseUri) {
            return this.parserService.dumpRaml(this.api);
        }
        String baseUriReplacement = this.getBaseUriReplacement(this.apiServer);
        return this.parserService.dumpRaml(this.api, baseUriReplacement);
    }

    public String getRamlV2(String resourceRelativePath) throws TypedException {
        if ((resourceRelativePath = this.sanitarizeResourceRelativePath(resourceRelativePath)).contains("..")) {
            throw ApikitErrorTypes.throwErrorType(new NotFoundException("\"..\" is not allowed"));
        }
        if (this.apiResourcesRelativePath.equals(resourceRelativePath)) {
            String rootRaml = this.parserService.dumpRaml(this.api);
            if (this.keepRamlBaseUri) {
                return rootRaml;
            }
            String baseUriReplacement = this.getBaseUriReplacement(this.apiServer);
            return UrlUtils.replaceBaseUri(rootRaml, baseUriReplacement);
        }
        if (!resourceRelativePath.contains("/")) {
            throw ApikitErrorTypes.throwErrorType(new NotFoundException("Requested resources should be in a subfolder"));
        }
        InputStream apiResource = null;
        ByteArrayOutputStream baos = null;
        try {
            apiResource = this.muleContext.getExecutionClassLoader().getResourceAsStream(resourceRelativePath);
            if (apiResource == null) {
                throw ApikitErrorTypes.throwErrorType(new NotFoundException(resourceRelativePath));
            }
            baos = new ByteArrayOutputStream();
            StreamUtils.copyLarge(apiResource, baos);
        }
        catch (IOException e) {
            try {
                logger.debug(e.getMessage());
                throw ApikitErrorTypes.throwErrorType(new NotFoundException(resourceRelativePath));
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(apiResource);
                IOUtils.closeQuietly(baos);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)apiResource);
        IOUtils.closeQuietly((OutputStream)baos);
        if (baos != null) {
            return baos.toString();
        }
        return null;
    }

    public String getBaseUriReplacement(String apiServer) {
        return UrlUtils.getBaseUriReplacement(apiServer);
    }

    public boolean isRequestingRamlV1ForConsole(String listenerPath, String requestPath, String queryString, String method, String acceptHeader) {
        String postalistenerPath = UrlUtils.getListenerPath(listenerPath, requestPath);
        return !(this.isParserV2() || !postalistenerPath.equals(requestPath) && !(postalistenerPath + "/").equals(requestPath) || !ActionType.GET.toString().equals(method.toUpperCase()) || !APPLICATION_RAML.equals(acceptHeader) && !queryString.equals(RAML_QUERY_STRING));
    }

    public boolean isRequestingRamlV2(String listenerPath, String requestPath, String queryString, String method) {
        String consolePath;
        String resourcesFullPath = consolePath = UrlUtils.getListenerPath(listenerPath, requestPath);
        if (!consolePath.endsWith("/")) {
            if (!this.apiResourcesRelativePath.startsWith("/")) {
                resourcesFullPath = resourcesFullPath + "/";
            }
            resourcesFullPath = resourcesFullPath + this.apiResourcesRelativePath;
        } else if (this.apiResourcesRelativePath.startsWith("/") && this.apiResourcesRelativePath.length() > 1) {
            resourcesFullPath = resourcesFullPath + this.apiResourcesRelativePath.substring(1);
        }
        return this.isParserV2() && queryString.equals(RAML_QUERY_STRING) && ActionType.GET.toString().equals(method.toUpperCase()) && requestPath.startsWith(resourcesFullPath);
    }

    private String sanitarizeResourceRelativePath(String resourceRelativePath) {
        if (resourceRelativePath.startsWith("/") && resourceRelativePath.length() > 1) {
            resourceRelativePath = resourceRelativePath.substring(1, resourceRelativePath.length());
        }
        if (resourceRelativePath.contains("?raml")) {
            resourceRelativePath = resourceRelativePath.substring(0, resourceRelativePath.indexOf(63));
        }
        if (resourceRelativePath.endsWith("/") && resourceRelativePath.length() > 1) {
            resourceRelativePath = resourceRelativePath.substring(0, resourceRelativePath.length() - 1);
        }
        return resourceRelativePath;
    }

    private String findRootRaml(String ramlLocation) {
        try {
            URL url = new URL(ramlLocation);
            return url.toString();
        }
        catch (MalformedURLException e) {
            String[] startingLocations;
            for (String start : startingLocations = new String[]{"", "api/", "api"}) {
                URL ramlLocationUrl = Thread.currentThread().getContextClassLoader().getResource(start + ramlLocation);
                if (ramlLocationUrl == null) continue;
                return start + ramlLocation;
            }
            return null;
        }
    }

    public String getRootRamlLocationForV2() {
        return "this.location.href + '" + this.apiResourcesRelativePath + "/?" + RAML_QUERY_STRING + "'";
    }

    public String getRootRamlLocationForV1() {
        return "this.location.href + '?raml'";
    }

    public String getSuccessStatusCode(IAction action) {
        for (String status : action.getResponses().keySet()) {
            int code = Integer.parseInt(status);
            if (code < 200 || code >= 300) continue;
            return status;
        }
        return "200";
    }

    public void setApiServer(String apiServer) {
        this.apiServer = apiServer;
    }
}

