/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.uri;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.text.Normalizer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class URICoder {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private URICoder() {
    }

    public static String encode(String s) {
        return URICoder.encode(s, '0');
    }

    public static String encode(String s, Set<Character> chars) {
        if (s.length() == 0) {
            return s;
        }
        boolean ascii = URICoder.isASCII(s);
        return ascii ? URICoder.encode_ASCII(s, chars) : URICoder.encode_UTF8(s, chars);
    }

    public static String encode(String s, char c) {
        return URICoder.encode(s, new HashSet<Character>(Arrays.asList(Character.valueOf(c))));
    }

    public static String minimalEncode(String s) {
        if (s.length() == 0) {
            return s;
        }
        boolean ascii = URICoder.isASCII(s);
        return ascii ? URICoder.minimalEncode_ASCII(s) : URICoder.minimalEncode_UTF8(s);
    }

    private static String encode_ASCII(String s, Set<Character> chars) {
        StringBuffer sb = new StringBuffer();
        for (char c : s.toCharArray()) {
            if (URICoder.isUnreserved(c) || chars.contains(Character.valueOf(c))) {
                sb.append(c);
                continue;
            }
            URICoder.appendEscape(sb, c);
        }
        return sb.toString();
    }

    private static String minimalEncode_ASCII(String s) {
        StringBuffer sb = new StringBuffer();
        for (char c : s.toCharArray()) {
            if (URICoder.isLegal(c)) {
                sb.append(c);
                continue;
            }
            URICoder.appendEscape(sb, c);
        }
        return sb.toString();
    }

    private static String encode_UTF8(String s, Set<Character> chars) {
        String n = Normalizer.isNormalized(s, Normalizer.Form.NFKC) ? s : Normalizer.normalize(s, Normalizer.Form.NFKC);
        ByteBuffer bb = UTF8.encode(n);
        StringBuffer sb = new StringBuffer();
        while (bb.hasRemaining()) {
            int b = bb.get() & 0xFF;
            if (URICoder.isUnreserved(b) || chars.contains(Character.valueOf((char)b))) {
                sb.append((char)b);
                continue;
            }
            URICoder.appendEscape(sb, (byte)b);
        }
        return sb.toString();
    }

    private static String minimalEncode_UTF8(String s) {
        String n = Normalizer.isNormalized(s, Normalizer.Form.NFKC) ? s : Normalizer.normalize(s, Normalizer.Form.NFKC);
        ByteBuffer bb = UTF8.encode(n);
        StringBuffer sb = new StringBuffer();
        while (bb.hasRemaining()) {
            int b = bb.get() & 0xFF;
            if (URICoder.isLegal(b)) {
                sb.append((char)b);
                continue;
            }
            URICoder.appendEscape(sb, (byte)b);
        }
        return sb.toString();
    }

    public static String decode(String s) {
        if (s.length() == 0 || s.indexOf(37) < 0 && s.indexOf(43) < 0) {
            return s;
        }
        boolean ascii = URICoder.isEncodedASCII(s);
        return ascii ? URICoder.decode_ASCII(s) : URICoder.decode_UTF8(s);
    }

    private static String decode_ASCII(String s) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '%') {
                String hex;
                char x;
                if (i >= s.length() - 2) continue;
                if ((x = (char)Integer.parseInt(hex = String.copyValueOf(new char[]{s.charAt(++i), s.charAt(++i)}), 16)) != '/') {
                    sb.append(x);
                    continue;
                }
                sb.append("%2F");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static String decode_UTF8(String s) {
        ByteBuffer bb = ByteBuffer.allocate(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '%') {
                if (i >= s.length() - 2) continue;
                String hex = "" + s.charAt(++i) + s.charAt(++i);
                byte b = (byte)Integer.parseInt(hex, 16);
                if (b != 47) {
                    bb.put(b);
                    continue;
                }
                bb.put("%2F".getBytes());
                continue;
            }
            bb.put((byte)c);
        }
        bb.limit(bb.position());
        bb.position(0);
        return UTF8.decode(bb).toString();
    }

    private static void appendEscape(StringBuffer sb, byte b) {
        sb.append('%');
        sb.append(HEX_DIGITS[b >> 4 & 0xF]);
        sb.append(HEX_DIGITS[b >> 0 & 0xF]);
    }

    private static void appendEscape(StringBuffer sb, char c) {
        sb.append('%');
        sb.append(HEX_DIGITS[c >> 4 & 0xF]);
        sb.append(HEX_DIGITS[c >> 0 & 0xF]);
    }

    private static boolean isUnreserved(int c) {
        if (c >= 97 && c <= 122) {
            return true;
        }
        if (c >= 65 && c <= 90) {
            return true;
        }
        if (c >= 48 && c <= 57) {
            return true;
        }
        return c == 46 || c == 95 || c == 45 || c == 126;
    }

    private static boolean isLegal(int c) {
        if (c < 38 && c != 33 && c != 35 && c != 36) {
            return false;
        }
        if (c >= 123 && c != 126) {
            return false;
        }
        return c != 96 && c != 60 && c != 62 && c != 92 && c != 94;
    }

    private static boolean isASCII(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) < '\u0080') continue;
            return false;
        }
        return true;
    }

    private static boolean isEncodedASCII(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != '%' || i >= s.length() - 1 || s.charAt(i + 1) <= '7') continue;
            return false;
        }
        return true;
    }
}

