/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.apikit.common.FlowName;
import org.mule.module.apikit.ApikitErrorTypes;
import org.mule.module.apikit.FlowMapping;
import org.mule.module.apikit.api.RamlHandler;
import org.mule.module.apikit.api.RoutingTable;
import org.mule.module.apikit.api.uri.URIPattern;
import org.mule.module.apikit.api.uri.URIResolver;
import org.mule.module.apikit.exception.NotImplementedException;
import org.mule.module.apikit.exception.UnsupportedMediaTypeException;
import org.mule.raml.interfaces.model.IAction;
import org.mule.raml.interfaces.model.IRaml;
import org.mule.raml.interfaces.model.IResource;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.core.api.construct.Flow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowFinder {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Map<String, IResource> flatResourceTree = new HashMap<String, IResource>();
    private Map<String, Flow> restFlowMap;
    private Map<String, Flow> restFlowMapUnwrapped;
    protected RoutingTable routingTable;
    private RamlHandler ramlHandler;
    private String configName;
    private List<FlowMapping> flowMappings;
    private ConfigurationComponentLocator locator;

    public FlowFinder(RamlHandler ramlHandler, String configName, ConfigurationComponentLocator locator, List<FlowMapping> flowMappings) {
        this.ramlHandler = ramlHandler;
        this.configName = configName;
        this.flowMappings = flowMappings;
        this.locator = locator;
        this.initializeRestFlowMap();
        this.loadRoutingTable();
    }

    protected void initializeRestFlowMap() {
        IRaml api = this.ramlHandler.getApi();
        this.flattenResourceTree(api.getResources(), api.getVersion());
        if (this.restFlowMap == null) {
            this.restFlowMap = new HashMap<String, Flow>();
            List<Flow> flows = this.getFlows();
            for (Flow flow : flows) {
                String key = this.getRestFlowKey(flow.getName());
                if (key == null) continue;
                this.restFlowMap.put(key, flow);
            }
            for (FlowMapping mapping : this.flowMappings) {
                for (Flow flow : flows) {
                    if (!flow.getName().equals(mapping.getFlowRef())) continue;
                    mapping.setFlow(flow);
                    this.restFlowMap.put(mapping.getKey(), mapping.getFlow());
                }
            }
            this.logMissingMappings(api.getVersion());
            this.restFlowMapUnwrapped = new HashMap<String, Flow>(this.restFlowMap);
        }
    }

    private List<Flow> getFlows() {
        List annotatedObjects = this.locator.find(ComponentIdentifier.builder().name("flow").namespace("mule").build());
        return annotatedObjects;
    }

    private void flattenResourceTree(Map<String, IResource> resources, String version) {
        for (IResource resource : resources.values()) {
            this.flatResourceTree.put(resource.getResolvedUri(version), resource);
            if (resource.getResources() == null) continue;
            this.flattenResourceTree(resource.getResources(), version);
        }
    }

    public Map<String, Flow> getRawRestFlowMap() {
        return this.restFlowMap;
    }

    private String getRestFlowKey(String name) {
        String[] validMethods = new String[]{"get", "put", "post", "delete", "head", "patch", "options"};
        String[] coords = FlowName.decode((String)name).split(":");
        if (coords.length < 2) {
            return null;
        }
        String method = coords[0];
        String resource = coords[1];
        if (coords.length > 4 || !Arrays.asList(validMethods).contains(method) || !resource.startsWith("/")) {
            return null;
        }
        if (coords.length == 4) {
            if (coords[3].equals(this.configName)) {
                String contentType = coords[2];
                return this.validateRestFlowKeyAgainstApi(method, resource, contentType);
            }
            return null;
        }
        if (coords.length == 3 && !coords[2].equals(this.configName)) {
            String contentType = coords[2];
            return this.validateRestFlowKeyAgainstApi(method, resource, contentType);
        }
        return this.validateRestFlowKeyAgainstApi(method, resource);
    }

    private String validateRestFlowKeyAgainstApi(String ... coords) {
        IAction action;
        IResource apiResource;
        String method = coords[0];
        String resource = coords[1];
        String type = coords.length == 3 ? coords[2] : null;
        String key = String.format("%s:%s", method, resource);
        if (type != null) {
            key = key + ":" + type;
        }
        if ((apiResource = this.flatResourceTree.get(resource)) != null && (action = apiResource.getAction(method)) != null) {
            if (type == null) {
                return key;
            }
            if (action.hasBody() && action.getBody().get(type) != null) {
                return key;
            }
        }
        this.logger.warn(String.format("Flow named \"%s\" does not match any RAML descriptor resource", key));
        return null;
    }

    private void logMissingMappings(String version) {
        for (IResource resource : this.flatResourceTree.values()) {
            String fullResource = resource.getResolvedUri(version);
            for (IAction action : resource.getActions().values()) {
                String method = action.getType().name().toLowerCase();
                String key = method + ":" + fullResource;
                if (this.restFlowMap.get(key) != null) continue;
                if (action.hasBody()) {
                    for (String contentType : action.getBody().keySet()) {
                        if (this.restFlowMap.get(key + ":" + contentType) != null) continue;
                        this.logger.warn(String.format("Action-Resource-ContentType triplet has no implementation -> %s:%s:%s ", method, fullResource, contentType));
                    }
                    continue;
                }
                this.logger.warn(String.format("Action-Resource pair has no implementation -> %s:%s ", method, fullResource));
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("==== RestFlows defined:");
            for (String key : this.restFlowMap.keySet()) {
                this.logger.debug("\t\t" + key);
            }
        }
    }

    private void loadRoutingTable() {
        if (this.routingTable == null) {
            this.routingTable = new RoutingTable(this.ramlHandler.getApi());
        }
    }

    public Flow getFlow(IResource resource, String method, String contentType) throws UnsupportedMediaTypeException {
        String baseKey = method + ":" + resource.getResolvedUri(this.ramlHandler.getApi().getVersion());
        Map<String, Flow> rawRestFlowMap = this.getRawRestFlowMap();
        Flow flow = rawRestFlowMap.get(baseKey + ":" + contentType);
        if (flow == null && (flow = rawRestFlowMap.get(baseKey)) == null) {
            if (this.isFlowDeclaredWithDifferentMediaType(rawRestFlowMap, baseKey)) {
                throw ApikitErrorTypes.throwErrorType(new UnsupportedMediaTypeException());
            }
            throw ApikitErrorTypes.throwErrorType(new NotImplementedException());
        }
        return flow;
    }

    public IResource getResource(URIPattern uriPattern) {
        return this.routingTable.getResource(uriPattern);
    }

    private boolean isFlowDeclaredWithDifferentMediaType(Map<String, Flow> map, String baseKey) {
        for (String flowName : map.keySet()) {
            String[] split = flowName.split(":");
            String methodAndResoruce = split[0] + ":" + split[1];
            if (!methodAndResoruce.equals(baseKey)) continue;
            return true;
        }
        return false;
    }

    public URIPattern findBestMatch(URIResolver resolver) {
        return resolver.find(this.routingTable.keySet(), URIResolver.MatchRule.BEST_MATCH);
    }
}

