/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.aggregator.internal.storage.content;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.mule.extension.aggregator.internal.storage.content.AbstractAggregatedContent;
import org.mule.runtime.api.metadata.TypedValue;

public class SimpleAggregatedContent
extends AbstractAggregatedContent {
    private static final long serialVersionUID = -229638907750317297L;
    @Deprecated
    private Map<Integer, TypedValue> sequencedElements = new HashMap<Integer, TypedValue>();
    @Deprecated
    private List<TypedValue> unsequencedElements = new ArrayList<TypedValue>();

    private SimpleAggregatedContent() {
    }

    public SimpleAggregatedContent(int maxSize) {
        this();
        this.maxSize = maxSize;
    }

    private void updateTimes(Long timeStamp) {
        if (this.firstElementArrivalTime == null) {
            this.firstElementArrivalTime = timeStamp;
        }
        this.lastElementArrivalTime = timeStamp;
    }

    @Override
    public void add(TypedValue newContent, Long timeStamp) {
        this.unsequencedElements.add(newContent);
        this.updateTimes(timeStamp);
    }

    @Override
    public void add(TypedValue newContent, Long timeStamp, int sequenceNumber) {
        SequencedElement sequencedElement = this.sequencedElements.containsKey(sequenceNumber) ? (SequencedElement)this.sequencedElements.get(sequenceNumber).getValue() : new SequencedElement();
        sequencedElement.add(newContent);
        this.sequencedElements.put(sequenceNumber, TypedValue.of((Object)sequencedElement));
        this.updateTimes(timeStamp);
    }

    @Override
    public List<TypedValue> getAggregatedElements() {
        List<Object> orderedElements = new ArrayList<TypedValue>();
        if (this.sequencedElements.size() > 0) {
            orderedElements = this.sequencedElements.entrySet().stream().sorted(Comparator.comparingInt(Map.Entry::getKey)).flatMap(val -> ((SequencedElement)((TypedValue)val.getValue()).getValue()).get().stream()).collect(Collectors.toList());
        }
        orderedElements.addAll(this.unsequencedElements);
        return orderedElements;
    }

    @Override
    public boolean isComplete() {
        Integer sequencedElementsSize = this.sequencedElements.values().stream().map(v -> ((SequencedElement)v.getValue()).size()).reduce(0, Integer::sum);
        return this.maxSize == this.unsequencedElements.size() + sequencedElementsSize;
    }

    @Override
    @Deprecated
    public boolean upgradeIfNeeded() {
        if (this.sequencedElements.isEmpty()) {
            return false;
        }
        boolean isUpgraded = this.sequencedElements.values().stream().anyMatch(v -> v.getValue() instanceof SequencedElement);
        if (!isUpgraded) {
            HashMap<Integer, TypedValue> indexedElements = new HashMap<Integer, TypedValue>();
            for (Integer key : this.sequencedElements.keySet()) {
                SequencedElement sequencedElement = new SequencedElement();
                sequencedElement.add(this.sequencedElements.get(key));
                indexedElements.put(key, TypedValue.of((Object)sequencedElement));
            }
            this.sequencedElements.clear();
            this.sequencedElements = indexedElements;
            return true;
        }
        return false;
    }

    private static class Index
    implements Serializable {
        private static final long serialVersionUID = -8286760373914606346L;
        private Integer sequenceNumber = null;
        private int arrivalIndex = 0;

        public Index(int arrivalIndex) {
            this.arrivalIndex = arrivalIndex;
        }

        public Index(int arrivalIndex, int sequenceNumber) {
            this(arrivalIndex);
            this.sequenceNumber = sequenceNumber;
        }

        public Integer getSequenceNumber() {
            return this.sequenceNumber;
        }

        public int getArrivalIndex() {
            return this.arrivalIndex;
        }
    }

    @Deprecated
    private static class SequencedElement
    implements Serializable {
        private static final long serialVersionUID = -5278813073775940619L;
        private List<TypedValue> aggregatedElements = new ArrayList<TypedValue>();

        SequencedElement() {
        }

        void add(TypedValue value) {
            this.aggregatedElements.add(value);
        }

        List<TypedValue> get() {
            return Collections.unmodifiableList(this.aggregatedElements);
        }

        int size() {
            return this.aggregatedElements.size();
        }
    }
}

