/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.aggregator.internal.privileged.executor;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.mule.extension.aggregator.internal.errors.AggregatorError;
import org.mule.extension.aggregator.internal.parameter.TimeBasedAggregatorParameterGroup;
import org.mule.extension.aggregator.internal.privileged.CompletionCallbackWrapper;
import org.mule.extension.aggregator.internal.privileged.executor.SingleGroupAggregatorExecutor;
import org.mule.extension.aggregator.internal.routes.IncrementalAggregationRoute;
import org.mule.extension.aggregator.internal.storage.content.AggregatedContent;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.ItemSequenceInfo;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.module.extension.api.runtime.privileged.ExecutionContextAdapter;
import org.reactivestreams.Publisher;

public class TimeBasedAggregatorOperationsExecutor
extends SingleGroupAggregatorExecutor {
    private static final String AGGREGATOR_KEY = "TimeBasedAggregator";
    private int maxSize;

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public TimeBasedAggregatorOperationsExecutor(Map<String, Object> params) {
        this.injectParameters(params);
    }

    public Publisher<Object> execute(ExecutionContext<OperationModel> executionContext) {
        ExecutionContextAdapter context = (ExecutionContextAdapter)executionContext;
        CoreEvent event = context.getEvent();
        IncrementalAggregationRoute incrementalAggregationRoute = (IncrementalAggregationRoute)((Object)context.getParameter("incrementalAggregation"));
        TimeBasedAggregatorParameterGroup parameters = this.createParameters(context.getParameters());
        Optional<ItemSequenceInfo> itemSequenceInfo = this.getItemSequenceInfo(executionContext);
        this.aggregate(parameters, incrementalAggregationRoute, new CompletionCallbackWrapper((CompletionCallback)context.getVariable("MULE_COMPLETION_CALLBACK_CONTEXT_PARAM"), event), itemSequenceInfo);
        return null;
    }

    private TimeBasedAggregatorParameterGroup createParameters(Map<String, Object> parameterMap) {
        TimeBasedAggregatorParameterGroup parameters = new TimeBasedAggregatorParameterGroup();
        parameters.setContent((TypedValue)parameterMap.get("content"));
        parameters.setPeriod((Integer)parameterMap.get("period"));
        parameters.setPeriodUnit((TimeUnit)((Object)parameterMap.get("periodUnit")));
        return parameters;
    }

    @Override
    protected void injectParameters(Map<String, Object> parameters) {
        super.injectParameters(parameters);
        this.maxSize = (Integer)parameters.get("maxSize");
    }

    @Override
    public void initialise() throws InitialisationException {
        super.initialise();
        this.setGroupSize(this.maxSize);
    }

    @Override
    String doGetAggregatorKey() {
        return AGGREGATOR_KEY;
    }

    private void aggregate(TimeBasedAggregatorParameterGroup aggregatorParameters, IncrementalAggregationRoute incrementalAggregationRoute, CompletionCallbackWrapper completionCallback, Optional<ItemSequenceInfo> itemSequenceInfo) {
        this.evaluateParameters(aggregatorParameters);
        CompletableFuture<Result<Object, Object>> future = new CompletableFuture<Result<Object, Object>>();
        this.executeSynchronized(() -> {
            this.registerAsyncAggregationIfNeeded(aggregatorParameters.getPeriod(), aggregatorParameters.getPeriodUnit());
            AggregatedContent aggregatedContent = this.getAggregatedContent();
            this.addToStorage(aggregatedContent, aggregatorParameters.getContent(), itemSequenceInfo);
            if (aggregatedContent.isComplete()) {
                this.notifyListenerOnComplete(aggregatedContent.getAggregatedElements(), this.getAttributes(this.getAggregatedContent()));
                this.onCompleteAggregation();
                future.complete(Result.builder().build());
            } else if (incrementalAggregationRoute != null) {
                this.executeRouteWithAggregatedElements(incrementalAggregationRoute, aggregatedContent.getAggregatedElements(), this.getAttributes(aggregatedContent), future);
            } else {
                future.complete(Result.builder().build());
            }
            return true;
        });
        this.finishExecution(future, completionCallback);
    }

    private void evaluateParameters(TimeBasedAggregatorParameterGroup parameterGroup) {
        if (parameterGroup.getPeriod() <= 0) {
            throw new ModuleException(String.format("A configured period of %d is not valid. Value should be bigger than 0", parameterGroup.getPeriod()), (ErrorTypeDefinition)AggregatorError.AGGREGATOR_CONFIG);
        }
        this.evaluateConfiguredDelay("period", parameterGroup.getPeriod(), parameterGroup.getPeriodUnit());
        if (this.maxSize == 0) {
            throw new ModuleException("maxSize can't be 0", (ErrorTypeDefinition)AggregatorError.AGGREGATOR_CONFIG);
        }
    }

    @Override
    void onAsyncAggregationExecution() {
        this.getElementsAndNotifyListener();
    }

    private void getElementsAndNotifyListener() {
        this.notifyListenerOnComplete(this.getAggregatedContent().getAggregatedElements(), this.getAttributes(this.getAggregatedContent()));
        this.resetGroup();
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug("Aggregation period complete");
        }
    }
}

