/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extensions.java.internal;

import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.mule.extensions.java.api.exception.ArgumentMismatchModuleException;
import org.mule.extensions.java.api.exception.ClassNotFoundModuleException;
import org.mule.extensions.java.api.exception.InvocationModuleException;
import org.mule.extensions.java.api.exception.NoSuchMethodModuleException;
import org.mule.extensions.java.api.exception.WrongTypeModuleException;
import org.mule.extensions.java.internal.cache.JavaModuleLoadingCache;
import org.mule.extensions.java.internal.transformer.ParameterTransformer;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.transformation.TransformationService;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.util.ClassUtils;

public final class JavaModuleUtils {
    public static final String ARG_0 = "arg0";
    public static final String ARG_PREFIX = "arg";

    private JavaModuleUtils() {
    }

    public static void validateType(String clazz, Object instance, boolean acceptSubtypes, JavaModuleLoadingCache cache) throws ClassNotFoundModuleException, WrongTypeModuleException {
        boolean isValid;
        Class<?> declaredClass = cache.loadClass(clazz);
        boolean bl = isValid = acceptSubtypes ? ClassUtils.isInstance(declaredClass, (Object)instance) : declaredClass.equals(instance.getClass());
        if (!isValid) {
            throw new WrongTypeModuleException(clazz, instance.getClass().getName());
        }
    }

    public static Object invokeMethod(Method method, Map<String, TypedValue<Object>> args, Object instance, Supplier<String> failureMessageProvider, TransformationService transformationService, ExpressionManager expressionManager) throws ArgumentMismatchModuleException, InvocationModuleException, NoSuchMethodModuleException {
        try {
            List<Object> sortedArgs = JavaModuleUtils.getSortedAndTransformedArgs(args, method, transformationService, expressionManager);
            if (sortedArgs.size() == method.getParameters().length) {
                return method.invoke(instance, sortedArgs.toArray());
            }
            throw new ArgumentMismatchModuleException(failureMessageProvider.get(), method, args);
        }
        catch (IllegalArgumentException e) {
            throw new ArgumentMismatchModuleException(failureMessageProvider.get(), (Executable)method, args, (Throwable)e);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new InvocationModuleException(failureMessageProvider.get(), args, (Throwable)e);
        }
    }

    public static List<Object> getSortedAndTransformedArgs(Map<String, TypedValue<Object>> args, Executable executable, TransformationService transformationService, ExpressionManager expressionManager) {
        Parameter[] parameters = executable.getParameters();
        if (parameters.length == 0) {
            return Collections.emptyList();
        }
        boolean useCanonicalArgName = args.containsKey(ARG_0);
        ParameterTransformer parameterTransformer = new ParameterTransformer(executable, transformationService, expressionManager);
        ArrayList<Object> sortedArgs = new ArrayList<Object>(parameters.length);
        for (int i = 0; i < parameters.length; ++i) {
            TypedValue<Object> value;
            Parameter parameter = parameters[i];
            TypedValue<Object> typedValue = value = useCanonicalArgName ? args.get(ARG_PREFIX + i) : args.get(parameter.getName());
            if (value == null) break;
            Object transformedParameter = value.getValue();
            if (parameterTransformer.parameterNeedsTransformation(value.getValue(), i)) {
                transformedParameter = parameterTransformer.transformParameter(value.getValue(), i);
            }
            sortedArgs.add(transformedParameter);
        }
        return sortedArgs;
    }
}

