/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extensions.java.api.exception;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.mule.extensions.java.api.error.JavaModuleError;
import org.mule.extensions.java.api.exception.JavaModuleException;
import org.mule.extensions.java.internal.parameters.ExecutableIdentifier;
import org.mule.extensions.java.internal.parameters.ExecutableIdentifierFactory;
import org.mule.runtime.api.metadata.TypedValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoSuchMethodModuleException
extends JavaModuleException {
    private static final Logger LOGGER = LoggerFactory.getLogger(NoSuchMethodModuleException.class);

    public NoSuchMethodModuleException(ExecutableIdentifier id, Class<?> targetClass, List<Method> methods, Map<String, TypedValue<Object>> args) {
        super(NoSuchMethodModuleException.buildMessage(id.getElementId(), targetClass, methods, NoSuchMethodModuleException.toHumanReadableArgs(args)), JavaModuleError.NO_SUCH_METHOD);
    }

    public NoSuchMethodModuleException(String id, Class<?> targetClass, List<Method> methods, List<Object> args) {
        super(NoSuchMethodModuleException.buildMessage(id, targetClass, methods, NoSuchMethodModuleException.toHumanReadableArgs(args)), JavaModuleError.NO_SUCH_METHOD);
    }

    private static String buildMessage(String id, Class<?> targetClass, List<Method> methods, List<String> args) {
        String msg = String.format("No public Method found with name [%s] in class [%s] with arguments %s.", id, targetClass.getName(), args);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(msg + " Available public Methods are: " + methods.stream().map(c -> ExecutableIdentifierFactory.create(c).getElementId()).collect(Collectors.toList()));
        }
        return msg;
    }
}

