/*
 * Decompiled with CFR 0.152.
 */
package org.mule.example.scripting;

import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.MessageFactory;
import org.mule.transformer.AbstractTransformer;
import org.mule.util.NumberUtils;

public class SimpleMathTransformer
extends AbstractTransformer {
    private String operation = "add";
    private double factor;

    public SimpleMathTransformer() {
        this.registerSourceType(Number.class);
        this.setReturnClass(Number.class);
    }

    public Object doTransform(Object src, String encoding) throws TransformerException {
        double result;
        double data = NumberUtils.toDouble((Object)src);
        if (data == -9.99999999E8) {
            throw new TransformerException(MessageFactory.createStaticMessage((String)("Unable to convert message to double: " + src)));
        }
        if (this.operation.equalsIgnoreCase("add")) {
            result = data + this.factor;
        } else if (this.operation.equalsIgnoreCase("subtract")) {
            result = data - this.factor;
        } else if (this.operation.equalsIgnoreCase("multiply")) {
            result = data * this.factor;
        } else if (this.operation.equalsIgnoreCase("divide")) {
            result = data / this.factor;
        } else {
            throw new TransformerException(MessageFactory.createStaticMessage((String)("Operation " + this.operation + " not recognized")));
        }
        return new Double(result);
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public double getFactor() {
        return this.factor;
    }

    public void setFactor(double factor) {
        this.factor = factor;
    }
}

