/*
 * Decompiled with CFR 0.152.
 */
package org.mule.samples.scripting;

import junit.framework.TestCase;
import org.mule.MuleManager;
import org.mule.MuleServer;

public abstract class SimpleRunner
extends TestCase {
    protected String config = null;

    public SimpleRunner(String config) {
        this.config = config;
    }

    public static boolean serverIsStarted() {
        if (MuleManager.isInstanciated()) {
            return MuleManager.getInstance().isStarted();
        }
        return false;
    }

    public void testRunner() throws Exception {
        this.runSample();
    }

    protected void setUp() throws Exception {
        MuleServer server = new MuleServer(this.config);
        server.start(true);
        while (!SimpleRunner.serverIsStarted()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                System.exit(0);
            }
        }
    }

    protected void tearDown() throws Exception {
        MuleManager.getInstance().dispose();
    }

    protected void log(String msg) {
        System.out.println(msg);
    }

    protected void log(String msg, Throwable t) {
        System.err.println(msg + ": " + t.getMessage());
        t.printStackTrace(System.err);
    }

    protected abstract void runSample() throws Exception;
}

