/*
 * Decompiled with CFR 0.152.
 */
package org.mule.samples.scripting;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.mule.extras.client.MuleClient;
import org.mule.samples.scripting.SimpleRunner;
import org.mule.transformers.simple.ByteArrayToSerializable;
import org.mule.umo.UMOMessage;

public class BinaryHttpExample
extends SimpleRunner {
    public BinaryHttpExample() {
        super("BinaryHttpExample.xml");
    }

    public static void main(String[] args) {
        TestSuite suite = new TestSuite(BinaryHttpExample.class);
        TestResult result = new TestResult();
        suite.run(result);
    }

    protected void runSample() throws Exception {
        MuleClient client = new MuleClient();
        List<Integer> serviceArgs = Arrays.asList(new Integer(42));
        UMOMessage replyMsg = client.send("ServiceEndpoint", serviceArgs, null);
        BinaryHttpExample.assertNotNull((Object)replyMsg);
        this.log("replyMsg: " + replyMsg);
        Object payload = replyMsg.getPayload();
        BinaryHttpExample.assertNotNull((Object)payload);
        this.log("payload.class: " + payload.getClass());
        Object obj = new ByteArrayToSerializable().doTransform(payload, null);
        this.log("object.class: " + obj.getClass());
        this.log("Received Response: " + obj);
        BinaryHttpExample.assertTrue((boolean)(obj instanceof ArrayList));
        List results = (List)obj;
        BinaryHttpExample.assertEquals((int)2, (int)results.size());
        BinaryHttpExample.assertEquals((Object)"Hello", results.get(0));
        BinaryHttpExample.assertEquals((Object)":-)", results.get(1));
    }
}

