/*
 * Decompiled with CFR 0.152.
 */
package org.mule.example.bookstore;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.jws.WebService;
import org.mule.DefaultMuleMessage;
import org.mule.RequestContext;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.example.bookstore.Book;
import org.mule.example.bookstore.Bookstore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@WebService(serviceName="BookstoreService", portName="BookstorePort", endpointInterface="org.mule.example.bookstore.Bookstore")
public class BookstoreImpl
implements Bookstore {
    private Map<Long, Book> books = new HashMap<Long, Book>();

    @Override
    public long addBook(Book book) {
        System.out.println("Adding book " + book.getTitle());
        long id = this.books.size() + 1;
        book.setId(id);
        this.books.put(id, book);
        return id;
    }

    @Override
    public Collection<Long> addBooks(Collection<Book> books) {
        ArrayList<Long> ids = new ArrayList<Long>();
        if (books != null) {
            for (Book book : books) {
                ids.add(this.addBook(book));
            }
        }
        return ids;
    }

    @Override
    public Collection<Book> getBooks() {
        return this.books.values();
    }

    @Override
    public void orderBook(long bookId, String address, String email) {
        try {
            Book book = this.books.get(bookId);
            DefaultMuleMessage msg = new DefaultMuleMessage((Object)new Object[]{book, address, email});
            RequestContext.getEventContext().dispatchEvent((MuleMessage)msg, "orderEmailService");
            System.out.println("Dispatched message to orderService.");
        }
        catch (MuleException e) {
            throw new RuntimeException(e);
        }
    }
}

