/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.lexical.formatstype;

import com.mulesoft.flatfile.lexical.ErrorHandler;
import com.mulesoft.flatfile.lexical.LexicalException;
import com.mulesoft.lexical.formatstype.BaseFormatter;
import com.mulesoft.lexical.formatstype.ClassPatternMatching;
import com.mulesoft.lexical.formatstype.ExpectedClass;
import com.mulesoft.lexical.formatstype.PadConverter;
import com.mulesoft.lexical.formatstype.SignConverterFunction;
import com.mulesoft.lexical.formatstype.SingleConverter;
import com.mulesoft.lexical.formatstype.TruncateConverter;
import com.mulesoft.lexical.formatstype.TypeBaseFormat;
import com.mulesoft.lexical.formatstype.validation.LongLengthValidation;
import com.mulesoft.lexical.formatstype.validation.ShortLengthValidation;
import com.mulesoft.lexical.formatstype.validation.TruncateCondition;
import java.math.BigDecimal;
import java.math.BigInteger;

public class ExplicitDecimalFormatter
extends BaseFormatter<BigDecimal> {
    private static ExplicitDecimalFormatter instance;

    public static ExplicitDecimalFormatter getInstance() {
        if (instance == null) {
            instance = new ExplicitDecimalFormatter();
        }
        return instance;
    }

    private ExplicitDecimalFormatter() {
        this.withPatternMatching(new ExpectedClass<BigDecimal>(BigDecimal.class));
        this.withPatternMatching(new ClassPatternMatching<BigDecimal>(new Class[]{BigInteger.class, Long.class, Integer.class, Double.class, Float.class}){

            @Override
            protected BigDecimal apply(Object value) {
                return new BigDecimal(value.toString());
            }
        });
        this.withOutputConverter(new PadConverter());
        this.withOutputConverter(new SingleConverter(new SignConverterFunction()));
        this.withOutputConverter(new TruncateConverter(true).withCondition(new TruncateCondition()));
        this.withOutputConverter(new SingleConverter((value, typeFormat, handler) -> {
            if (value.startsWith("0.") && !typeFormat.getZeroBeforeDecimal()) {
                return value.substring(1);
            }
            if (value.startsWith("-0.") && !typeFormat.getZeroBeforeDecimal()) {
                return "-" + value.substring(2);
            }
            return value;
        }));
        this.withValidation(new LongLengthValidation());
        this.withValidation(new ShortLengthValidation());
    }

    @Override
    protected BigDecimal valueToUseForWrong(Object value, TypeBaseFormat typeFormat, ErrorHandler handler) {
        return null;
    }

    @Override
    protected BigDecimal valueToUseForNull(TypeBaseFormat typeFormat, ErrorHandler handler) {
        return null;
    }

    @Override
    protected String doFormat(BigDecimal value, TypeBaseFormat typeFormat, ErrorHandler handler) throws LexicalException {
        if (value.equals(new BigDecimal(0))) {
            return "0";
        }
        String plainString = this.removeStartingZeroIfApply(typeFormat, value.toPlainString());
        if (plainString.length() <= typeFormat.maxLength(plainString) || !typeFormat.getAllowExponent()) {
            return plainString;
        }
        BigDecimal adjusted = value.movePointRight(value.scale());
        String text = adjusted.toBigIntegerExact().toString() + (value.scale() == 0 ? "" : "E" + Integer.toString(-value.scale()));
        return this.removeStartingZeroIfApply(typeFormat, text);
    }

    private String removeStartingZeroIfApply(TypeBaseFormat typeFormat, String text) {
        return !typeFormat.getZeroBeforeDecimal() && text.startsWith("0") ? text.substring(1) : text;
    }
}

