/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.lexical.formatstype;

import com.mulesoft.flatfile.lexical.ErrorHandler;
import com.mulesoft.flatfile.lexical.LexicalException;
import com.mulesoft.lexical.formatstype.CompositeConverter;
import com.mulesoft.lexical.formatstype.FormatError;
import com.mulesoft.lexical.formatstype.IntegerNumberFactory;
import com.mulesoft.lexical.formatstype.InvalidCharacterOnDecimal;
import com.mulesoft.lexical.formatstype.SingleConverter;
import com.mulesoft.lexical.formatstype.StripConverter;
import com.mulesoft.lexical.formatstype.TruncateConverter;
import com.mulesoft.lexical.formatstype.TypeBaseFormat;
import com.mulesoft.lexical.formatstype.validation.LongLengthValidation;
import com.mulesoft.lexical.formatstype.validation.ShortLengthValidation;
import com.mulesoft.lexical.formatstype.validation.TruncateCondition;
import com.mulesoft.lexical.formatstype.validation.TypeFormatValidation;
import java.math.BigDecimal;

public class ExplicitDecimalConverter
extends CompositeConverter<Number> {
    private static ExplicitDecimalConverter instance;

    public static ExplicitDecimalConverter getInstance() {
        if (instance == null) {
            instance = new ExplicitDecimalConverter();
        }
        return instance;
    }

    private ExplicitDecimalConverter() {
        this.addValidation(new ShortLengthValidation());
        this.addValidation(new LongLengthValidation());
        this.addValidation(new TypeFormatValidation<String>((value, typeFormat, handler) -> {
            if (typeFormat.getNumberSign().forceSign() && value.charAt(0) != '-' && value.charAt(0) != '+') {
                FormatError.missingRequiredSign(handler, typeFormat);
            }
            return value;
        }));
        this.addConverter(new StripConverter());
        this.addConverter(new SingleConverter(new InvalidCharacterOnDecimal()));
        this.addConverter(new SingleConverter((value, typeFormat, handler) -> value.length() == 0 ? "0" : value));
        this.addConverter(new TruncateConverter(true).withCondition(new TruncateCondition()));
    }

    @Override
    public Number doConvert(String value, ErrorHandler handler, TypeBaseFormat typeFormat) throws LexicalException {
        BigDecimal decimalValue = new BigDecimal(value);
        if (value.contains("E") || value.contains(".")) {
            return decimalValue;
        }
        return decimalValue.scale() > 0 ? decimalValue : IntegerNumberFactory.getInstance().getIntegerObject(decimalValue.toBigInteger());
    }
}

