/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.lexical.formatstype;

import com.mulesoft.flatfile.lexical.ErrorHandler;
import com.mulesoft.flatfile.lexical.LexicalException;
import com.mulesoft.lexical.formatstype.FormatError;
import com.mulesoft.lexical.formatstype.PatternMatchingConverter;
import com.mulesoft.lexical.formatstype.TypeBaseFormat;
import com.mulesoft.lexical.formatstype.TypeFormatConverter;
import com.mulesoft.lexical.formatstype.validation.Validation;

public abstract class ClassPatternMatching<A>
implements PatternMatchingConverter,
TypeFormatConverter<A, Object>,
Validation<Object> {
    private Class[] clazzes;

    public ClassPatternMatching(Class ... clazz) {
        if (clazz.length == 0) {
            throw new IllegalArgumentException("At least one class should be defined");
        }
        this.clazzes = clazz;
    }

    @Override
    public boolean match(Object value) {
        for (Class clazz : this.clazzes) {
            if (!clazz.isInstance(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A convert(Object value, ErrorHandler handler, TypeBaseFormat typeFormat) throws LexicalException {
        this.validate(value, typeFormat, handler, true);
        return this.apply(value);
    }

    @Override
    public void validate(Object value, TypeBaseFormat typeFormat, ErrorHandler handler) throws LexicalException {
        this.validate(value, typeFormat, handler, false);
    }

    private void validate(Object value, TypeBaseFormat typeFormat, ErrorHandler handler, boolean throwExcp) throws LexicalException {
        if (!this.match(value)) {
            FormatError.wrongType(value, handler, typeFormat);
            if (throwExcp) {
                throw new LexicalException("Invalid type " + value.getClass());
            }
        }
    }

    protected abstract A apply(Object var1);
}

