/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.lexical.formatstype;

import com.mulesoft.flatfile.lexical.TypeFormatConstants;
import com.mulesoft.lexical.formatstype.SingleConverter;
import org.apache.commons.lang3.StringUtils;

public class PadConverter
extends SingleConverter {
    public PadConverter() {
        this(true);
    }

    public PadConverter(boolean withMinusSign) {
        super((value, typeFormat, handler) -> {
            if (TypeFormatConstants.FillMode.ZEROES.equals((Object)typeFormat.getFillMode()) && typeFormat.getFill() != '0') {
                throw new IllegalArgumentException("Fill Zero is expected");
            }
            switch (typeFormat.getFillMode()) {
                case LEFT: {
                    return StringUtils.rightPad((String)value, (int)typeFormat.minLength((String)value), (char)typeFormat.getFill());
                }
                case ZEROES: 
                case RIGHT: {
                    if (withMinusSign && value.length() > 0 && value.charAt(0) == '-') {
                        return "-" + StringUtils.leftPad((String)value.substring(1), (int)(typeFormat.minLength((String)value) - 1), (char)typeFormat.getFill());
                    }
                    return StringUtils.leftPad((String)value, (int)typeFormat.minLength((String)value), (char)typeFormat.getFill());
                }
            }
            return value;
        });
    }
}

