/*
 * Decompiled with CFR 0.152.
 */
package org.mule.amf.impl.parser.factory;

import amf.apicontract.client.platform.AMFBaseUnitClient;
import amf.apicontract.client.platform.AMFConfiguration;
import amf.apicontract.client.platform.APIConfiguration;
import amf.core.client.common.transform.PipelineId;
import amf.core.client.platform.AMFParseResult;
import amf.core.client.platform.execution.BaseExecutionEnvironment;
import amf.core.client.platform.execution.ExecutionEnvironment;
import amf.core.client.platform.model.document.BaseUnit;
import amf.core.client.platform.model.document.Document;
import amf.core.client.platform.resource.ResourceLoader;
import amf.core.client.platform.validation.AMFValidationReport;
import amf.core.client.platform.validation.AMFValidationResult;
import amf.core.internal.remote.Spec;
import java.io.File;
import java.net.URI;
import java.net.URLDecoder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.mule.amf.impl.exceptions.ParserException;
import org.mule.amf.impl.loader.ExchangeDependencyResourceLoader;
import org.mule.amf.impl.loader.ProvidedResourceLoader;
import org.mule.apikit.model.api.ApiReference;

public class AMFParserWrapper {
    private final ApiReference apiRef;
    private final ExecutionEnvironment executionEnvironment;
    private AMFBaseUnitClient client;
    private List<AMFValidationResult> parsingIssues;
    private AMFConfiguration amfConfiguration;
    private Spec spec;

    public AMFParserWrapper(ApiReference apiRef, ExecutionEnvironment execEnv) {
        URI apiUri;
        this.apiRef = apiRef;
        this.executionEnvironment = execEnv;
        this.amfConfiguration = APIConfiguration.API().withExecutionEnvironment((BaseExecutionEnvironment)execEnv);
        if (apiRef.getResourceLoader().isPresent()) {
            this.amfConfiguration = this.amfConfiguration.withResourceLoader((ResourceLoader)new ProvidedResourceLoader((org.mule.apikit.loader.ResourceLoader)apiRef.getResourceLoader().get()));
        }
        if ((apiUri = apiRef.getPathAsUri()).getScheme() != null && apiUri.getScheme().startsWith("file")) {
            File file = new File(apiUri);
            String rootDir = file.isDirectory() ? file.getPath() : file.getParent();
            this.amfConfiguration = this.amfConfiguration.withResourceLoader((ResourceLoader)new ExchangeDependencyResourceLoader(rootDir, execEnv));
        }
    }

    public Document parseApi() throws ParserException {
        AMFParseResult amfParseResult = (AMFParseResult)this.handleFuture(this.amfConfiguration.baseUnitClient().parse(URLDecoder.decode(this.apiRef.getPathAsUri().toString())));
        this.parsingIssues = amfParseResult.results();
        BaseUnit model = amfParseResult.baseUnit();
        this.spec = amfParseResult.sourceSpec();
        this.amfConfiguration = APIConfiguration.fromSpec((Spec)this.spec).withExecutionEnvironment((BaseExecutionEnvironment)this.executionEnvironment);
        this.client = this.amfConfiguration.baseUnitClient();
        return (Document)this.client.transform(model, PipelineId.Editing()).baseUnit();
    }

    public AMFValidationReport getParsingReport(Document resolvedDoc) throws ParserException {
        return (AMFValidationReport)this.handleFuture(this.client.validate((BaseUnit)resolvedDoc));
    }

    private <T, U> U handleFuture(CompletableFuture<T> f) throws ParserException {
        try {
            return (U)f.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw AMFParserWrapper.getParseException(e);
        }
        catch (Exception e) {
            throw AMFParserWrapper.getParseException(e);
        }
    }

    private static ParserException getParseException(Exception e) {
        throw new ParserException("An error happened while parsing the api. Message: " + e.getMessage(), e);
    }

    public AMFConfiguration getAMFConfiguration() {
        return this.amfConfiguration;
    }

    public List<AMFValidationResult> getParsingIssues() {
        return this.parsingIssues;
    }

    public Spec getSpec() {
        return this.spec;
    }

    public ExecutionEnvironment getExecutionEnvironment() {
        return this.executionEnvironment;
    }
}

