/*
 * Decompiled with CFR 0.152.
 */
package org.mule.amf.impl.parser.factory;

import amf.MessageStyles;
import amf.ProfileNames;
import amf.client.environment.DefaultEnvironment;
import amf.client.environment.Environment;
import amf.client.execution.BaseExecutionEnvironment;
import amf.client.execution.ExecutionEnvironment;
import amf.client.parse.Oas20Parser;
import amf.client.parse.Oas20YamlParser;
import amf.client.parse.Parser;
import amf.client.parse.Raml08Parser;
import amf.client.parse.Raml10Parser;
import amf.client.parse.RamlParser;
import amf.client.resolve.Oas20Resolver;
import amf.client.resolve.Raml08Resolver;
import amf.client.resolve.Raml10Resolver;
import amf.client.resolve.Resolver;
import java.io.File;
import java.net.URI;
import java.util.Optional;
import org.mule.amf.impl.exceptions.ParserException;
import org.mule.amf.impl.loader.ExchangeDependencyResourceLoader;
import org.mule.amf.impl.loader.ProvidedResourceLoader;
import org.mule.amf.impl.parser.factory.AMFParserWrapper;
import org.mule.apikit.loader.ResourceLoader;
import org.mule.apikit.model.ApiFormat;
import org.mule.apikit.model.ApiVendor;
import org.mule.apikit.model.api.ApiReference;

public class AMFParserWrapperFactory {
    private AMFParserWrapperFactory() {
    }

    public static AMFParserWrapper getParser(ApiReference apiRef, ExecutionEnvironment execEnv) {
        if (execEnv == null) {
            throw new RuntimeException("ExecutionEnvironment is mandatory");
        }
        ApiVendor apiVendor = apiRef.getVendor();
        String apiFormat = apiRef.getFormat();
        Environment environment = AMFParserWrapperFactory.buildEnvironment(apiRef, execEnv);
        switch (apiVendor) {
            case RAML_10: {
                return new AMFParserWrapper(environment, (Parser)new Raml10Parser(environment), (Resolver)new Raml10Resolver(), ProfileNames.RAML10(), MessageStyles.RAML());
            }
            case RAML_08: {
                return new AMFParserWrapper(environment, (Parser)new Raml08Parser(environment), (Resolver)new Raml10Resolver(), ProfileNames.RAML(), MessageStyles.RAML());
            }
            case OAS: 
            case OAS_20: {
                Oas20Parser oas20Parser = ApiFormat.JSON.name().equalsIgnoreCase(apiFormat) ? new Oas20Parser(environment) : new Oas20YamlParser(environment);
                return new AMFParserWrapper(environment, (Parser)oas20Parser, (Resolver)new Oas20Resolver(), ProfileNames.OAS20(), MessageStyles.OAS());
            }
            case OAS_30: {
                throw new ParserException("API implementations based on OAS 3.0 specs are not supported at this time");
            }
        }
        return new AMFParserWrapper(environment, (Parser)new RamlParser(environment), (Resolver)new Raml08Resolver(), ProfileNames.AMF(), MessageStyles.AMF());
    }

    private static Environment buildEnvironment(ApiReference apiRef, ExecutionEnvironment executionEnvironment) {
        Optional resourceLoader;
        Environment environment = DefaultEnvironment.apply((BaseExecutionEnvironment)executionEnvironment);
        URI apiUri = apiRef.getPathAsUri();
        if (apiUri.getScheme() != null && apiUri.getScheme().startsWith("file")) {
            File file = new File(apiUri);
            String rootDir = file.isDirectory() ? file.getPath() : file.getParent();
            environment = environment.add((amf.client.resource.ResourceLoader)new ExchangeDependencyResourceLoader(rootDir, executionEnvironment));
        }
        if ((resourceLoader = apiRef.getResourceLoader()).isPresent()) {
            environment = environment.add((amf.client.resource.ResourceLoader)new ProvidedResourceLoader((ResourceLoader)resourceLoader.get()));
        }
        return environment;
    }
}

