/*
 * Decompiled with CFR 0.152.
 */
package org.mule.amf.impl.model;

import amf.client.model.domain.AnyShape;
import amf.client.model.domain.ArrayShape;
import amf.client.model.domain.ScalarShape;
import amf.client.model.domain.UnionShape;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.mule.amf.impl.model.JsonParameterValidationStrategy;
import org.mule.amf.impl.model.ParameterValidationStrategy;
import org.mule.amf.impl.model.YamlParameterValidationStrategy;

class ParameterValidationStrategyFactory {
    private static final Set<String> NUMBER_DATA_TYPES = ImmutableSet.of((Object)"integer", (Object)"float", (Object)"number", (Object)"long", (Object)"double");

    private ParameterValidationStrategyFactory() {
        throw new IllegalStateException("Utility class");
    }

    static ParameterValidationStrategy getStrategy(AnyShape anyShape) {
        return ParameterValidationStrategyFactory.isYamlValidationNeeded(anyShape) ? new YamlParameterValidationStrategy(anyShape) : ParameterValidationStrategyFactory.getJsonParameterValidationStrategy(anyShape);
    }

    private static JsonParameterValidationStrategy getJsonParameterValidationStrategy(AnyShape anyShape) {
        if (!(anyShape instanceof ScalarShape)) {
            return new JsonParameterValidationStrategy(anyShape, false, false);
        }
        String dataType = ((ScalarShape)anyShape).dataType().value();
        dataType = dataType.substring(dataType.lastIndexOf(35) + 1);
        boolean isNumber = NUMBER_DATA_TYPES.contains(dataType);
        boolean isBoolean = dataType.equals("boolean");
        return new JsonParameterValidationStrategy(anyShape, !isNumber && !isBoolean, isBoolean);
    }

    private static boolean isYamlValidationNeeded(AnyShape anyShape) {
        return anyShape instanceof ArrayShape || anyShape instanceof UnionShape;
    }
}

