/*
 * Decompiled with CFR 0.152.
 */
package org.mule.amf.impl.model;

import amf.client.model.domain.AnyShape;
import amf.client.model.domain.ArrayShape;
import amf.client.model.domain.NodeShape;
import amf.client.model.domain.PropertyShape;
import amf.client.model.domain.ScalarShape;
import amf.client.validate.PayloadValidator;
import amf.client.validate.ValidationReport;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.mule.amf.impl.model.MediaType;
import org.mule.amf.impl.model.ParameterImpl;
import org.mule.apikit.model.QueryString;
import org.mule.apikit.model.parameter.Parameter;

public class QueryStringImpl
implements QueryString {
    private AnyShape schema;
    private final Map<String, Optional<PayloadValidator>> payloadValidatorMap = new HashMap<String, Optional<PayloadValidator>>();
    private final String defaultMediaType = "application/yaml";

    public QueryStringImpl(AnyShape anyShape) {
        this.schema = anyShape;
    }

    public String getDefaultValue() {
        return this.schema.defaultValueStr().option().orElse(null);
    }

    public boolean isArray() {
        return this.schema instanceof ArrayShape;
    }

    public boolean validate(String value) {
        return this.validatePayload(value).conforms();
    }

    private ValidationReport validatePayload(String value) {
        Optional payloadValidator;
        String mimeType = MediaType.getMimeTypeForValue(value);
        if (!this.payloadValidatorMap.containsKey(mimeType)) {
            payloadValidator = this.schema.payloadValidator(mimeType);
            if (!payloadValidator.isPresent()) {
                payloadValidator = this.schema.payloadValidator("application/yaml");
            }
            this.payloadValidatorMap.put(mimeType, payloadValidator);
        } else {
            payloadValidator = this.payloadValidatorMap.get(mimeType);
        }
        if (payloadValidator.isPresent()) {
            try {
                return (ValidationReport)payloadValidator.get().validate(mimeType, value).get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException("Unexpected Error validating request", e);
            }
        }
        throw new RuntimeException("Unexpected Error validating request");
    }

    public boolean isScalar() {
        return this.schema instanceof ScalarShape;
    }

    public boolean isFacetArray(String facet) {
        if (this.schema instanceof NodeShape) {
            for (PropertyShape type : ((NodeShape)this.schema).properties()) {
                if (!facet.equals(type.name().value())) continue;
                return type.range() instanceof ArrayShape;
            }
        }
        return false;
    }

    public Map<String, Parameter> facets() {
        HashMap<String, Parameter> result = new HashMap<String, Parameter>();
        if (this.schema instanceof NodeShape) {
            for (PropertyShape type : ((NodeShape)this.schema).properties()) {
                result.put(type.name().value(), new ParameterImpl(type));
            }
        }
        return result;
    }
}

