/*
 * Decompiled with CFR 0.152.
 */
package mozilla.components.support.utils;

import android.net.Uri;
import android.webkit.MimeTypeMap;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rH\u0002J&\u0010\u0010\u001a\u00020\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\r2\b\u0010\u0012\u001a\u0004\u0018\u00010\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\rH\u0007J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0011\u001a\u00020\rH\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lmozilla/components/support/utils/DownloadUtils;", "", "()V", "CONTENT_DISPOSITION_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "ENCODED_FILE_NAME_GROUP", "", "ENCODED_SYMBOL_PATTERN", "ENCODING_GROUP", "QUOTED_FILE_NAME_GROUP", "UNQUOTED_FILE_NAME", "decodeHeaderField", "", "field", "encoding", "guessFileName", "contentDisposition", "url", "mimeType", "parseContentDisposition", "utils_release"})
public final class DownloadUtils {
    private static final Pattern CONTENT_DISPOSITION_PATTERN;
    private static final int ENCODED_FILE_NAME_GROUP = 5;
    private static final int ENCODING_GROUP = 4;
    private static final int QUOTED_FILE_NAME_GROUP = 3;
    private static final int UNQUOTED_FILE_NAME = 2;
    private static final Pattern ENCODED_SYMBOL_PATTERN;
    public static final DownloadUtils INSTANCE;

    /*
     * Enabled aggressive block sorting
     */
    @JvmStatic
    @NotNull
    public static final String guessFileName(@Nullable String contentDisposition, @Nullable String url, @Nullable String mimeType) {
        int dotIndex;
        String decodedUrl;
        String string;
        int index;
        String filename = null;
        String extension = null;
        if (contentDisposition != null && (filename = INSTANCE.parseContentDisposition(contentDisposition)) != null && (index = StringsKt.lastIndexOf$default((CharSequence)filename, (char)'/', (int)0, (boolean)false, (int)6, null) + 1) > 0) {
            string = filename;
            String string2 = string.substring(index);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
            filename = string2;
        }
        if (filename == null && (decodedUrl = Uri.decode((String)url)) != null) {
            int index2;
            int queryIndex = StringsKt.indexOf$default((CharSequence)decodedUrl, (char)'?', (int)0, (boolean)false, (int)6, null);
            if (queryIndex > 0) {
                String string3 = decodedUrl;
                int n = 0;
                String string4 = string3.substring(n, queryIndex);
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                decodedUrl = string4;
            }
            if (!StringsKt.endsWith$default((String)decodedUrl, (String)"/", (boolean)false, (int)2, null) && (index2 = StringsKt.lastIndexOf$default((CharSequence)decodedUrl, (char)'/', (int)0, (boolean)false, (int)6, null) + 1) > 0) {
                String string5;
                String string6 = string5 = decodedUrl;
                if (string6 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string7 = string6.substring(index2);
                Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.String).substring(startIndex)");
                filename = string7;
            }
        }
        if (filename == null) {
            filename = "downloadfile";
        }
        if ((dotIndex = StringsKt.indexOf$default((CharSequence)filename, (char)'.', (int)0, (boolean)false, (int)6, null)) < 0) {
            if (mimeType != null && (extension = MimeTypeMap.getSingleton().getExtensionFromMimeType(mimeType)) != null) {
                extension = "" + extension;
            }
            if (extension != null) return filename + extension;
            if (mimeType != null) {
                String queryIndex = mimeType;
                Locale locale = Locale.ROOT;
                Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.ROOT");
                Locale index2 = locale;
                String string8 = queryIndex.toLowerCase(index2);
                Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"(this as java.lang.String).toLowerCase(locale)");
                if (StringsKt.startsWith$default((String)string8, (String)"text/", (boolean)false, (int)2, null)) {
                    if (StringsKt.equals((String)mimeType, (String)"text/html", (boolean)true)) {
                        extension = ".html";
                        return filename + extension;
                    }
                    extension = ".txt";
                    return filename + extension;
                }
            }
            extension = ".bin";
            return filename + extension;
        }
        if (mimeType != null) {
            int lastDotIndex = StringsKt.lastIndexOf$default((CharSequence)filename, (char)'.', (int)0, (boolean)false, (int)6, null);
            String string9 = filename;
            int n = lastDotIndex + 1;
            MimeTypeMap mimeTypeMap = MimeTypeMap.getSingleton();
            String string10 = string9.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string10, (String)"(this as java.lang.String).substring(startIndex)");
            String string11 = string10;
            String typeFromExt = mimeTypeMap.getMimeTypeFromExtension(string11);
            if (typeFromExt != null && !StringsKt.equals((String)typeFromExt, (String)mimeType, (boolean)true) && (extension = MimeTypeMap.getSingleton().getExtensionFromMimeType(mimeType)) != null) {
                extension = "" + extension;
            }
        }
        if (extension == null) {
            string = filename;
            String string12 = string.substring(dotIndex);
            Intrinsics.checkExpressionValueIsNotNull((Object)string12, (String)"(this as java.lang.String).substring(startIndex)");
            extension = string12;
        }
        string = filename;
        int n = 0;
        String string13 = string.substring(n, dotIndex);
        Intrinsics.checkExpressionValueIsNotNull((Object)string13, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        filename = string13;
        return filename + extension;
    }

    private final String parseContentDisposition(String contentDisposition) {
        try {
            Matcher m = CONTENT_DISPOSITION_PATTERN.matcher(contentDisposition);
            if (m.find()) {
                String string;
                String encodedFileName = m.group(5);
                String encoding = m.group(4);
                if (encodedFileName != null) {
                    String string2 = encoding;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"encoding");
                    return this.decodeHeaderField(encodedFileName, string2);
                }
                String quotedFileName = m.group(3);
                if (quotedFileName != null) {
                    CharSequence charSequence = quotedFileName;
                    String string3 = "\\\\(.)";
                    string3 = new Regex(string3);
                    String string4 = "$1";
                    string = string3.replace(charSequence, string4);
                } else {
                    string = m.group(2);
                }
                return string;
            }
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return null;
    }

    private final String decodeHeaderField(String field, String encoding) throws UnsupportedEncodingException {
        Matcher m = ENCODED_SYMBOL_PATTERN.matcher(field);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        while (m.find()) {
            String symbol;
            String string = symbol = m.group();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"symbol");
            if (StringsKt.startsWith$default((String)string, (String)"%", (boolean)false, (int)2, null)) {
                String string2;
                String string3 = symbol;
                int n = 1;
                ByteArrayOutputStream byteArrayOutputStream = stream;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3.substring(n), (String)"(this as java.lang.String).substring(startIndex)");
                byteArrayOutputStream.write(Integer.parseInt(string2, 16));
                continue;
            }
            stream.write(symbol.charAt(0));
        }
        String string = stream.toString(encoding);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"stream.toString(encoding)");
        return string;
    }

    private DownloadUtils() {
    }

    static {
        DownloadUtils downloadUtils;
        INSTANCE = downloadUtils = new DownloadUtils();
        CONTENT_DISPOSITION_PATTERN = Pattern.compile("(inline|attachment)\\s*;\\s*filename\\s*=\\s*(\"((?:\\\\.|[^\"\\\\])*)\"|[^;]*)\\s*(?:;\\s*filename\\*\\s*=\\s*(utf-8|iso-8859-1)'[^']*'(\\S*))?", 2);
        ENCODED_SYMBOL_PATTERN = Pattern.compile("%[0-9a-f]{2}|[0-9a-z!#$&+-.^_`|~]", 2);
    }
}

