/*
 * Decompiled with CFR 0.152.
 */
package mozilla.components.utils;

import android.os.Handler;
import android.os.Looper;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \u0005*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lmozilla/components/utils/ThreadUtils;", "", "()V", "backgroundExecutorService", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "handler", "Landroid/os/Handler;", "uiThread", "Ljava/lang/Thread;", "assertOnUiThread", "", "postToBackgroundThread", "runnable", "Ljava/lang/Runnable;", "postToMainThread", "postToMainThreadDelayed", "delayMillis", "", "utils_release"})
public final class ThreadUtils {
    private static final ExecutorService backgroundExecutorService;
    private static final Handler handler;
    private static final Thread uiThread;
    public static final ThreadUtils INSTANCE;

    public final void postToBackgroundThread(@NotNull Runnable runnable) {
        Intrinsics.checkParameterIsNotNull((Object)runnable, (String)"runnable");
        backgroundExecutorService.submit(runnable);
    }

    public final void postToMainThread(@NotNull Runnable runnable) {
        Intrinsics.checkParameterIsNotNull((Object)runnable, (String)"runnable");
        handler.post(runnable);
    }

    public final void postToMainThreadDelayed(@NotNull Runnable runnable, long delayMillis) {
        Intrinsics.checkParameterIsNotNull((Object)runnable, (String)"runnable");
        handler.postDelayed(runnable, delayMillis);
    }

    public final void assertOnUiThread() {
        Thread currentThread;
        Thread thread = currentThread = Thread.currentThread();
        Intrinsics.checkExpressionValueIsNotNull((Object)thread, (String)"currentThread");
        long currentThreadId = thread.getId();
        Thread thread2 = uiThread;
        Intrinsics.checkExpressionValueIsNotNull((Object)thread2, (String)"uiThread");
        long expectedThreadId = thread2.getId();
        if (currentThreadId == expectedThreadId) {
            return;
        }
        throw (Throwable)new IllegalThreadStateException("Expected UI thread, but running on " + currentThread.getName());
    }

    private ThreadUtils() {
    }

    static {
        ThreadUtils threadUtils;
        INSTANCE = threadUtils = new ThreadUtils();
        backgroundExecutorService = Executors.newSingleThreadExecutor();
        handler = new Handler(Looper.getMainLooper());
        Looper looper = Looper.getMainLooper();
        Intrinsics.checkExpressionValueIsNotNull((Object)looper, (String)"Looper.getMainLooper()");
        uiThread = looper.getThread();
    }
}

