/*
 * Decompiled with CFR 0.152.
 */
package mozilla.components.feature.toolbar;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import mozilla.components.browser.session.Session;
import mozilla.components.browser.session.SessionManager;
import mozilla.components.concept.toolbar.Toolbar;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\t\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\u000fH\u0016J\b\u0010\u0011\u001a\u00020\u000fH\u0016J\b\u0010\u0012\u001a\u00020\u000fH\u0016J\b\u0010\u0013\u001a\u00020\u000fH\u0016J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\u0015\u001a\u00020\u000fH\u0016J\u0006\u0010\u0016\u001a\u00020\u000fJ\u0006\u0010\u0017\u001a\u00020\u000fR\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lmozilla/components/feature/toolbar/ToolbarPresenter;", "Lmozilla/components/browser/session/SessionManager$Observer;", "Lmozilla/components/browser/session/Session$Observer;", "toolbar", "Lmozilla/components/concept/toolbar/Toolbar;", "sessionManager", "Lmozilla/components/browser/session/SessionManager;", "(Lmozilla/components/concept/toolbar/Toolbar;Lmozilla/components/browser/session/SessionManager;)V", "session", "Lmozilla/components/browser/session/Session;", "getSession", "()Lmozilla/components/browser/session/Session;", "setSession", "(Lmozilla/components/browser/session/Session;)V", "initializeView", "", "onLoadingStateChanged", "onNavigationStateChanged", "onProgress", "onSearch", "onSessionSelected", "onUrlChanged", "start", "stop", "feature-toolbar_release"})
public final class ToolbarPresenter
implements SessionManager.Observer,
Session.Observer {
    @NotNull
    private Session session;
    private final Toolbar toolbar;
    private final SessionManager sessionManager;

    @NotNull
    public final Session getSession() {
        return this.session;
    }

    public final void setSession(@NotNull Session session) {
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"<set-?>");
        this.session = session;
    }

    public final void start() {
        this.session = this.sessionManager.getSelectedSession();
        this.sessionManager.register((SessionManager.Observer)this);
        this.session.register((Session.Observer)this);
        this.initializeView();
    }

    public final void stop() {
        this.sessionManager.unregister((SessionManager.Observer)this);
        this.session.unregister((Session.Observer)this);
    }

    public void onSessionSelected(@NotNull Session session) {
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        this.session.unregister((Session.Observer)this);
        this.session = session;
        session.register((Session.Observer)this);
        this.initializeView();
    }

    private final void initializeView() {
        this.toolbar.displayUrl(this.session.getUrl());
    }

    public void onUrlChanged() {
        this.toolbar.displayUrl(this.session.getUrl());
        this.toolbar.setSearchTerms(this.session.getSearchTerms());
    }

    public void onProgress() {
        this.toolbar.displayProgress(this.session.getProgress());
    }

    public void onSearch() {
        this.toolbar.setSearchTerms(this.session.getSearchTerms());
    }

    public void onLoadingStateChanged() {
    }

    public void onNavigationStateChanged() {
    }

    public ToolbarPresenter(@NotNull Toolbar toolbar, @NotNull SessionManager sessionManager) {
        Intrinsics.checkParameterIsNotNull((Object)toolbar, (String)"toolbar");
        Intrinsics.checkParameterIsNotNull((Object)sessionManager, (String)"sessionManager");
        this.toolbar = toolbar;
        this.sessionManager = sessionManager;
        this.session = this.sessionManager.getSelectedSession();
    }
}

