/*
 * Decompiled with CFR 0.152.
 */
package mozilla.components.feature.toolbar;

import android.graphics.Bitmap;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mozilla.components.browser.session.Download;
import mozilla.components.browser.session.Session;
import mozilla.components.browser.session.SessionManager;
import mozilla.components.browser.session.tab.CustomTabConfig;
import mozilla.components.concept.engine.HitResult;
import mozilla.components.concept.toolbar.Toolbar;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\u0018\u00002\u00020\u00012\u00020\u0002B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\bH\u0016J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u000bH\u0016J\u0018\u0010\u0015\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\bH\u0016J\u0006\u0010\u0017\u001a\u00020\rJ\u0006\u0010\u0018\u001a\u00020\rR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lmozilla/components/feature/toolbar/ToolbarPresenter;", "Lmozilla/components/browser/session/SessionManager$Observer;", "Lmozilla/components/browser/session/Session$Observer;", "toolbar", "Lmozilla/components/concept/toolbar/Toolbar;", "sessionManager", "Lmozilla/components/browser/session/SessionManager;", "sessionId", "", "(Lmozilla/components/concept/toolbar/Toolbar;Lmozilla/components/browser/session/SessionManager;Ljava/lang/String;)V", "activeSession", "Lmozilla/components/browser/session/Session;", "initializeView", "", "onProgress", "session", "progress", "", "onSearch", "searchTerms", "onSessionSelected", "onUrlChanged", "url", "start", "stop", "feature-toolbar_release"})
public final class ToolbarPresenter
implements SessionManager.Observer,
Session.Observer {
    private Session activeSession;
    private final Toolbar toolbar;
    private final SessionManager sessionManager;
    private final String sessionId;

    public final void start() {
        String string;
        block5: {
            Session session;
            ToolbarPresenter toolbarPresenter;
            Object object;
            ToolbarPresenter toolbarPresenter2;
            block4: {
                toolbarPresenter2 = this;
                string = this.sessionId;
                if (string == null) break block4;
                object = string;
                toolbarPresenter = toolbarPresenter2;
                String it = object;
                session = this.sessionManager.findSessionById(this.sessionId);
                toolbarPresenter2 = toolbarPresenter;
                string = session;
                if (string != null) break block5;
            }
            object = this;
            toolbarPresenter = toolbarPresenter2;
            ToolbarPresenter $receiver = (ToolbarPresenter)object;
            $receiver.sessionManager.register((SessionManager.Observer)$receiver);
            session = $receiver.sessionManager.getSelectedSession();
            toolbarPresenter2 = toolbarPresenter;
            string = session;
        }
        toolbarPresenter2.activeSession = string;
        Session session = this.activeSession;
        if (session != null) {
            session.register((Session.Observer)this);
        }
        this.initializeView();
    }

    public final void stop() {
        block0: {
            this.sessionManager.unregister((SessionManager.Observer)this);
            Session session = this.activeSession;
            if (session == null) break block0;
            session.unregister((Session.Observer)this);
        }
    }

    public void onSessionSelected(@NotNull Session session) {
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        Session session2 = this.activeSession;
        if (session2 != null) {
            session2.unregister((Session.Observer)this);
        }
        this.activeSession = session;
        session.register((Session.Observer)this);
        this.initializeView();
    }

    private final void initializeView() {
        block1: {
            Session session;
            Session session2 = this.activeSession;
            if (session2 == null) break block1;
            Session session3 = session = session2;
            this.toolbar.setUrl(session3.getUrl());
            Object object = session3.getCustomTabConfig();
            if (object != null && (object = object.getToolbarColor()) != null) {
                Object object2 = object;
                int it = ((Number)object2).intValue();
                this.toolbar.asView().setBackgroundColor(it);
            }
        }
    }

    public void onUrlChanged(@NotNull Session session, @NotNull String url) {
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        this.toolbar.setUrl(url);
        this.toolbar.setSearchTerms(session.getSearchTerms());
    }

    public void onProgress(@NotNull Session session, int progress) {
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        this.toolbar.displayProgress(progress);
    }

    public void onSearch(@NotNull Session session, @NotNull String searchTerms) {
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)searchTerms, (String)"searchTerms");
        this.toolbar.setSearchTerms(searchTerms);
    }

    public ToolbarPresenter(@NotNull Toolbar toolbar, @NotNull SessionManager sessionManager, @Nullable String sessionId) {
        Intrinsics.checkParameterIsNotNull((Object)toolbar, (String)"toolbar");
        Intrinsics.checkParameterIsNotNull((Object)sessionManager, (String)"sessionManager");
        this.toolbar = toolbar;
        this.sessionManager = sessionManager;
        this.sessionId = sessionId;
    }

    public /* synthetic */ ToolbarPresenter(Toolbar toolbar, SessionManager sessionManager, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string = null;
        }
        this(toolbar, sessionManager, string);
    }

    public void onAllSessionsRemoved() {
        SessionManager.Observer.DefaultImpls.onAllSessionsRemoved((SessionManager.Observer)this);
    }

    public void onSessionAdded(@NotNull Session session) {
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        SessionManager.Observer.DefaultImpls.onSessionAdded((SessionManager.Observer)this, (Session)session);
    }

    public void onSessionRemoved(@NotNull Session session) {
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        SessionManager.Observer.DefaultImpls.onSessionRemoved((SessionManager.Observer)this, (Session)session);
    }

    public void onCustomTabConfigChanged(@NotNull Session session, @Nullable CustomTabConfig customTabConfig) {
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        Session.Observer.DefaultImpls.onCustomTabConfigChanged((Session.Observer)this, (Session)session, (CustomTabConfig)customTabConfig);
    }

    public void onDesktopModeChanged(@NotNull Session session, boolean enabled) {
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        Session.Observer.DefaultImpls.onDesktopModeChanged((Session.Observer)this, (Session)session, (boolean)enabled);
    }

    public boolean onDownload(@NotNull Session session, @NotNull Download download) {
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)download, (String)"download");
        return Session.Observer.DefaultImpls.onDownload((Session.Observer)this, (Session)session, (Download)download);
    }

    public void onFindResult(@NotNull Session session, @NotNull Session.FindResult result) {
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
        Session.Observer.DefaultImpls.onFindResult((Session.Observer)this, (Session)session, (Session.FindResult)result);
    }

    public void onFullScreenChanged(@NotNull Session session, boolean enabled) {
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        Session.Observer.DefaultImpls.onFullScreenChanged((Session.Observer)this, (Session)session, (boolean)enabled);
    }

    public void onLoadingStateChanged(@NotNull Session session, boolean loading) {
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        Session.Observer.DefaultImpls.onLoadingStateChanged((Session.Observer)this, (Session)session, (boolean)loading);
    }

    public boolean onLongPress(@NotNull Session session, @NotNull HitResult hitResult) {
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)hitResult, (String)"hitResult");
        return Session.Observer.DefaultImpls.onLongPress((Session.Observer)this, (Session)session, (HitResult)hitResult);
    }

    public void onNavigationStateChanged(@NotNull Session session, boolean canGoBack, boolean canGoForward) {
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        Session.Observer.DefaultImpls.onNavigationStateChanged((Session.Observer)this, (Session)session, (boolean)canGoBack, (boolean)canGoForward);
    }

    public void onSecurityChanged(@NotNull Session session, @NotNull Session.SecurityInfo securityInfo) {
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)securityInfo, (String)"securityInfo");
        Session.Observer.DefaultImpls.onSecurityChanged((Session.Observer)this, (Session)session, (Session.SecurityInfo)securityInfo);
    }

    public void onThumbnailChanged(@NotNull Session session, @Nullable Bitmap bitmap) {
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        Session.Observer.DefaultImpls.onThumbnailChanged((Session.Observer)this, (Session)session, (Bitmap)bitmap);
    }

    public void onTitleChanged(@NotNull Session session, @NotNull String title) {
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        Session.Observer.DefaultImpls.onTitleChanged((Session.Observer)this, (Session)session, (String)title);
    }

    public void onTrackerBlocked(@NotNull Session session, @NotNull String blocked, @NotNull List<String> all) {
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)blocked, (String)"blocked");
        Intrinsics.checkParameterIsNotNull(all, (String)"all");
        Session.Observer.DefaultImpls.onTrackerBlocked((Session.Observer)this, (Session)session, (String)blocked, all);
    }

    public void onTrackerBlockingEnabledChanged(@NotNull Session session, boolean blockingEnabled) {
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        Session.Observer.DefaultImpls.onTrackerBlockingEnabledChanged((Session.Observer)this, (Session)session, (boolean)blockingEnabled);
    }
}

