/*
 * Decompiled with CFR 0.152.
 */
package mozilla.components.feature.session;

import android.content.Context;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mozilla.components.browser.session.Session;
import mozilla.components.browser.session.SessionManager;
import mozilla.components.concept.engine.Engine;
import mozilla.components.concept.engine.EngineSession;
import mozilla.components.concept.session.storage.SessionStorage;
import mozilla.components.feature.session.DefaultSessionStorage;
import mozilla.components.feature.session.SessionProxy;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u001a\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u0005H\u0007J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001a\u001a\u00020\u001bJ\u0006\u0010\u001f\u001a\u00020\u001eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lmozilla/components/feature/session/SessionProvider;", "", "context", "Landroid/content/Context;", "initialSession", "Lmozilla/components/browser/session/Session;", "sessionStorage", "Lmozilla/components/concept/session/storage/SessionStorage;", "savePeriodically", "", "saveIntervalInSeconds", "", "scheduler", "Ljava/util/concurrent/ScheduledExecutorService;", "(Landroid/content/Context;Lmozilla/components/browser/session/Session;Lmozilla/components/concept/session/storage/SessionStorage;ZJLjava/util/concurrent/ScheduledExecutorService;)V", "selectedSession", "getSelectedSession", "()Lmozilla/components/browser/session/Session;", "sessionManager", "Lmozilla/components/browser/session/SessionManager;", "getSessionManager", "()Lmozilla/components/browser/session/SessionManager;", "sessions", "", "Lmozilla/components/concept/engine/EngineSession;", "getOrCreateEngineSession", "engine", "Lmozilla/components/concept/engine/Engine;", "session", "start", "", "stop", "feature-session_release"})
public final class SessionProvider {
    private final Map<Session, EngineSession> sessions;
    @NotNull
    private final SessionManager sessionManager;
    private final Context context;
    private final SessionStorage sessionStorage;
    private final boolean savePeriodically;
    private final long saveIntervalInSeconds;
    private final ScheduledExecutorService scheduler;

    @NotNull
    public final SessionManager getSessionManager() {
        return this.sessionManager;
    }

    @NotNull
    public final Session getSelectedSession() {
        return this.sessionManager.getSelectedSession();
    }

    /*
     * WARNING - void declaration
     */
    public final void start(@NotNull Engine engine) {
        void restoredSessions;
        Intrinsics.checkParameterIsNotNull((Object)engine, (String)"engine");
        Pair pair = this.sessionStorage.restore(engine);
        Map map = (Map)pair.component1();
        String restoredSelectedSession = (String)pair.component2();
        this.sessions.putAll((Map<Session, EngineSession>)restoredSessions);
        Iterable $receiver$iv = this.sessions.keySet();
        for (Object element$iv : $receiver$iv) {
            Session it = (Session)element$iv;
            this.sessionManager.add(it, Intrinsics.areEqual((Object)it.getId(), (Object)restoredSelectedSession));
        }
        if (this.savePeriodically) {
            this.scheduler.scheduleAtFixedRate(new Runnable(this){
                final /* synthetic */ SessionProvider this$0;

                public final void run() {
                    SessionProvider.access$getSessionStorage$p(this.this$0).persist(SessionProvider.access$getSessions$p(this.this$0), this.this$0.getSelectedSession().getId());
                }
                {
                    this.this$0 = sessionProvider;
                }
            }, this.saveIntervalInSeconds, this.saveIntervalInSeconds, TimeUnit.SECONDS);
        }
    }

    @NotNull
    public final synchronized EngineSession getOrCreateEngineSession(@NotNull Engine engine, @NotNull Session session) {
        EngineSession engineSession;
        Intrinsics.checkParameterIsNotNull((Object)engine, (String)"engine");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        Map<Session, EngineSession> $receiver$iv = this.sessions;
        EngineSession value$iv = $receiver$iv.get(session);
        if (value$iv == null) {
            EngineSession engineSession2 = engine.createSession();
            new SessionProxy(session, engineSession2);
            engineSession2.loadUrl(session.getUrl());
            EngineSession answer$iv = engineSession2;
            $receiver$iv.put(session, answer$iv);
            engineSession = answer$iv;
        } else {
            engineSession = value$iv;
        }
        return engineSession;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ EngineSession getOrCreateEngineSession$default(SessionProvider sessionProvider, Engine engine, Session session, int n, Object object) {
        if ((n & 2) != 0) {
            session = sessionProvider.getSelectedSession();
        }
        return sessionProvider.getOrCreateEngineSession(engine, session);
    }

    public final void stop() {
        this.scheduler.shutdown();
    }

    public SessionProvider(@NotNull Context context, @NotNull Session initialSession, @NotNull SessionStorage sessionStorage, boolean savePeriodically, long saveIntervalInSeconds, @NotNull ScheduledExecutorService scheduler) {
        Map map;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)initialSession, (String)"initialSession");
        Intrinsics.checkParameterIsNotNull((Object)sessionStorage, (String)"sessionStorage");
        Intrinsics.checkParameterIsNotNull((Object)scheduler, (String)"scheduler");
        this.context = context;
        this.sessionStorage = sessionStorage;
        this.savePeriodically = savePeriodically;
        this.saveIntervalInSeconds = saveIntervalInSeconds;
        this.scheduler = scheduler;
        SessionProvider sessionProvider = this;
        sessionProvider.sessions = map = (Map)new LinkedHashMap();
        this.sessionManager = new SessionManager(initialSession);
    }

    public /* synthetic */ SessionProvider(Context context, Session session, SessionStorage sessionStorage, boolean bl, long l, ScheduledExecutorService scheduledExecutorService, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            session = new Session("", null, 2, null);
        }
        if ((n & 4) != 0) {
            sessionStorage = new DefaultSessionStorage(context);
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            l = 300L;
        }
        if ((n & 0x20) != 0) {
            ScheduledExecutorService scheduledExecutorService2 = Executors.newSingleThreadScheduledExecutor();
            Intrinsics.checkExpressionValueIsNotNull((Object)scheduledExecutorService2, (String)"Executors.newSingleThreadScheduledExecutor()");
            scheduledExecutorService = scheduledExecutorService2;
        }
        this(context, session, sessionStorage, bl, l, scheduledExecutorService);
    }

    @NotNull
    public static final /* synthetic */ SessionStorage access$getSessionStorage$p(SessionProvider $this) {
        return $this.sessionStorage;
    }

    @NotNull
    public static final /* synthetic */ Map access$getSessions$p(SessionProvider $this) {
        return $this.sessions;
    }
}

