/*
 * Decompiled with CFR 0.152.
 */
package mozilla.components.feature.session;

import android.content.Context;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import mozilla.components.browser.session.Session;
import mozilla.components.concept.engine.Engine;
import mozilla.components.concept.engine.EngineSession;
import mozilla.components.concept.session.storage.SessionStorage;
import org.jetbrains.annotations.NotNull;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002J$\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00060\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J(\u0010\u0013\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00060\u0010\u0012\u0004\u0012\u00020\u00120\u00142\u0006\u0010\u0007\u001a\u00020\bH\u0017J\u0010\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0006H\u0002J\u0010\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lmozilla/components/feature/session/DefaultSessionStorage;", "Lmozilla/components/concept/session/storage/SessionStorage;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "deserializeEngineSession", "Lmozilla/components/concept/engine/EngineSession;", "engine", "Lmozilla/components/concept/engine/Engine;", "json", "Lorg/json/JSONObject;", "deserializeSession", "Lmozilla/components/browser/session/Session;", "persist", "", "sessions", "", "selectedSession", "", "restore", "Lkotlin/Pair;", "serializeEngineSession", "engineSession", "serializeSession", "session", "feature-session_release"})
public final class DefaultSessionStorage
implements SessionStorage {
    private final Context context;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public synchronized Pair<Map<Session, EngineSession>, String> restore(@NotNull Engine engine) {
        Closeable closeable;
        Intrinsics.checkParameterIsNotNull((Object)engine, (String)"engine");
        Map sessions = new LinkedHashMap();
        try {
            Pair pair;
            closeable = this.context.openFileInput("mozilla_components_session_storage.json");
            Throwable throwable = null;
            try {
                FileInputStream it;
                FileInputStream fileInputStream = it = (FileInputStream)closeable;
                Intrinsics.checkExpressionValueIsNotNull((Object)fileInputStream, (String)"it");
                Closeable closeable2 = fileInputStream;
                Object object = Charsets.UTF_8;
                Object object2 = closeable2;
                object2 = new InputStreamReader((InputStream)object2, (Charset)object);
                int n = 8192;
                closeable2 = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
                object = null;
                try {
                    Object it2 = (BufferedReader)closeable2;
                    it2 = TextStreamsKt.readText((Reader)((Reader)it2));
                }
                catch (Throwable it2) {
                    object = it2;
                    throw it2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)object);
                }
                Object json = it2;
                JSONObject jsonRoot = new JSONObject((String)json);
                String selectedSessionId = jsonRoot.getString("selectedSession");
                jsonRoot.remove("selectedSession");
                jsonRoot.remove("version");
                Iterator iterator = jsonRoot.keys();
                Intrinsics.checkExpressionValueIsNotNull((Object)iterator, (String)"jsonRoot.keys()");
                Iterator $receiver$iv = iterator;
                Object object3 = object2 = $receiver$iv;
                while (object3.hasNext()) {
                    Object element$iv = object3.next();
                    String it3 = (String)element$iv;
                    JSONObject jsonSession = jsonRoot.getJSONObject(it3);
                    JSONObject jSONObject = jsonSession.getJSONObject("session");
                    Intrinsics.checkExpressionValueIsNotNull((Object)jSONObject, (String)"jsonSession.getJSONObject(SESSION_KEY)");
                    Session session = this.deserializeSession(jSONObject);
                    JSONObject jSONObject2 = jsonSession.getJSONObject("engineSession");
                    Intrinsics.checkExpressionValueIsNotNull((Object)jSONObject2, (String)"jsonSession.getJSONObject(ENGINE_SESSION_KEY)");
                    EngineSession engineSession = this.deserializeEngineSession(engine, jSONObject2);
                    sessions.put(session, engineSession);
                }
                pair = new Pair((Object)sessions, (Object)selectedSessionId);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            closeable = pair;
        }
        catch (FileNotFoundException _) {
            closeable = new Pair((Object)MapsKt.emptyMap(), (Object)"");
        }
        catch (JSONException _) {
            closeable = new Pair((Object)MapsKt.emptyMap(), (Object)"");
        }
        return closeable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean persist(@NotNull Map<Session, ? extends EngineSession> sessions, @NotNull String selectedSession) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(sessions, (String)"sessions");
        Intrinsics.checkParameterIsNotNull((Object)selectedSession, (String)"selectedSession");
        try {
            Object object;
            Object $receiver$iv;
            JSONObject json = new JSONObject();
            json.put("version", 1);
            json.put("selectedSession", (Object)selectedSession);
            Object object2 = $receiver$iv = sessions;
            Unit unit = object2.entrySet().iterator();
            while (unit.hasNext()) {
                Map.Entry<Session, ? extends EngineSession> element$iv;
                Map.Entry<Session, ? extends EngineSession> $session_engineSession = element$iv = unit.next();
                object = $session_engineSession;
                Session session = object.getKey();
                object = $session_engineSession;
                EngineSession engineSession = object.getValue();
                JSONObject sessionJson = new JSONObject();
                sessionJson.put("session", (Object)this.serializeSession(session));
                sessionJson.put("engineSession", (Object)this.serializeEngineSession(engineSession));
                json.put(session.getId(), (Object)sessionJson);
            }
            $receiver$iv = this.context.openFileOutput("mozilla_components_session_storage.json", 0);
            object2 = null;
            try {
                FileOutputStream it = (FileOutputStream)$receiver$iv;
                String string = json.toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"json.toString()");
                String string2 = string;
                FileOutputStream fileOutputStream = it;
                object = Charsets.UTF_8;
                String string3 = string2;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                byte[] byArray = string3.getBytes((Charset)object);
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                byte[] byArray2 = byArray;
                fileOutputStream.write(byArray2);
                unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)$receiver$iv, (Throwable)object2);
            }
            bl = true;
        }
        catch (FileNotFoundException _) {
            bl = false;
        }
        catch (JSONException _) {
            bl = false;
        }
        return bl;
    }

    private final JSONObject serializeSession(Session session) {
        JSONObject json = new JSONObject();
        json.put("url", (Object)session.getUrl());
        return json;
    }

    private final Session deserializeSession(JSONObject json) {
        String string = json.getString("url");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"json.getString(\"url\")");
        return new Session(string, null, 2, null);
    }

    private final JSONObject serializeEngineSession(EngineSession engineSession) {
        return new JSONObject();
    }

    private final EngineSession deserializeEngineSession(Engine engine, JSONObject json) {
        return engine.createSession();
    }

    public DefaultSessionStorage(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
    }
}

