/*
 * Decompiled with CFR 0.152.
 */
package mozilla.components.feature.session;

import android.content.Intent;
import android.text.TextUtils;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import mozilla.components.browser.session.Session;
import mozilla.components.browser.session.SessionManager;
import mozilla.components.browser.session.tab.CustomTabConfig;
import mozilla.components.feature.session.SessionUseCases;
import mozilla.components.support.utils.SafeIntent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\fJ&\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000f2\u0016\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00070\u000bj\u0002`\u0010J\u000e\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000fR\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00070\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R7\u0010\r\u001a\u001e\u0012\u0004\u0012\u00020\u000f\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00070\u000bj\u0002`\u00100\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R*\u0010\u0015\u001a\u001e\u0012\u0004\u0012\u00020\u000f\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00070\u000bj\u0002`\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lmozilla/components/feature/session/SessionIntentProcessor;", "", "sessionUseCases", "Lmozilla/components/feature/session/SessionUseCases;", "sessionManager", "Lmozilla/components/browser/session/SessionManager;", "useDefaultHandlers", "", "openNewTab", "(Lmozilla/components/feature/session/SessionUseCases;Lmozilla/components/browser/session/SessionManager;ZZ)V", "defaultActionViewHandler", "Lkotlin/Function1;", "Landroid/content/Intent;", "defaultHandlers", "", "", "Lmozilla/components/feature/session/IntentHandler;", "getDefaultHandlers", "()Ljava/util/Map;", "defaultHandlers$delegate", "Lkotlin/Lazy;", "handlers", "process", "intent", "registerHandler", "", "action", "handler", "unregisterHandler", "Companion", "feature-session_release"})
public final class SessionIntentProcessor {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final Function1<Intent, Boolean> defaultActionViewHandler;
    private final Lazy defaultHandlers$delegate;
    private final Map<String, Function1<Intent, Boolean>> handlers;
    private final SessionUseCases sessionUseCases;
    private final SessionManager sessionManager;
    private final boolean openNewTab;
    @NotNull
    public static final String ACTIVE_SESSION_ID = "activeSessionId";
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(SessionIntentProcessor.class), "defaultHandlers", "getDefaultHandlers()Ljava/util/Map;"))};
        Companion = new Companion(null);
    }

    private final Map<String, Function1<Intent, Boolean>> getDefaultHandlers() {
        Lazy lazy = this.defaultHandlers$delegate;
        SessionIntentProcessor sessionIntentProcessor = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (Map)lazy.getValue();
    }

    public final boolean process(@NotNull Intent intent) {
        Intrinsics.checkParameterIsNotNull((Object)intent, (String)"intent");
        Object object = this.handlers.get(intent.getAction());
        return object != null && (object = (Boolean)object.invoke((Object)intent)) != null ? (Boolean)object : false;
    }

    public final void registerHandler(@NotNull String action, @NotNull Function1<? super Intent, Boolean> handler) {
        Intrinsics.checkParameterIsNotNull((Object)action, (String)"action");
        Intrinsics.checkParameterIsNotNull(handler, (String)"handler");
        Map<String, Function1<Intent, Boolean>> map = this.handlers;
        Function1<? super Intent, Boolean> function1 = handler;
        map.put(action, function1);
    }

    public final void unregisterHandler(@NotNull String action) {
        Intrinsics.checkParameterIsNotNull((Object)action, (String)"action");
        this.handlers.remove(action);
    }

    public SessionIntentProcessor(@NotNull SessionUseCases sessionUseCases, @NotNull SessionManager sessionManager, boolean useDefaultHandlers, boolean openNewTab) {
        Map map;
        Intrinsics.checkParameterIsNotNull((Object)sessionUseCases, (String)"sessionUseCases");
        Intrinsics.checkParameterIsNotNull((Object)sessionManager, (String)"sessionManager");
        this.sessionUseCases = sessionUseCases;
        this.sessionManager = sessionManager;
        this.openNewTab = openNewTab;
        this.defaultActionViewHandler = (Function1)new Function1<Intent, Boolean>(this){
            final /* synthetic */ SessionIntentProcessor this$0;

            public final boolean invoke(@NotNull Intent intent) {
                boolean bl;
                String url;
                Intrinsics.checkParameterIsNotNull((Object)intent, (String)"intent");
                SafeIntent safeIntent = new SafeIntent(intent);
                String string = safeIntent.getDataString();
                if (string == null) {
                    string = url = "";
                }
                if (TextUtils.isEmpty((CharSequence)url)) {
                    bl = false;
                } else if (CustomTabConfig.Companion.isCustomTabIntent(safeIntent)) {
                    Session session;
                    Session $receiver = session = new Session(url, false, Session.Source.CUSTOM_TAB, null, null, 24, null);
                    $receiver.setCustomTabConfig(CustomTabConfig.Companion.createFromIntent(safeIntent));
                    Session session2 = session;
                    SessionManager.add$default((SessionManager)SessionIntentProcessor.access$getSessionManager$p(this.this$0), (Session)session2, (boolean)false, null, (int)6, null);
                    SessionIntentProcessor.access$getSessionUseCases$p(this.this$0).getLoadUrl().invoke(url, session2);
                    intent.putExtra("activeSessionId", session2.getId());
                    bl = true;
                } else {
                    Session session;
                    if (SessionIntentProcessor.access$getOpenNewTab$p(this.this$0)) {
                        Session session3;
                        Session it = session3 = new Session(url, false, Session.Source.ACTION_VIEW, null, null, 24, null);
                        SessionManager.add$default((SessionManager)SessionIntentProcessor.access$getSessionManager$p(this.this$0), (Session)it, (boolean)true, null, (int)4, null);
                        session = session3;
                    } else {
                        session = SessionIntentProcessor.access$getSessionManager$p(this.this$0).getSelectedSession();
                        if (session == null) {
                            session = new Session(url, false, Session.Source.ACTION_VIEW, null, null, 24, null);
                        }
                    }
                    Session session4 = session;
                    SessionIntentProcessor.access$getSessionUseCases$p(this.this$0).getLoadUrl().invoke(url, session4);
                    bl = true;
                }
                return bl;
            }
            {
                this.this$0 = sessionIntentProcessor;
                super(1);
            }
        };
        this.defaultHandlers$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Map<String, Function1<? super Intent, ? extends Boolean>>>(this){
            final /* synthetic */ SessionIntentProcessor this$0;

            @NotNull
            public final Map<String, Function1<Intent, Boolean>> invoke() {
                return MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"android.intent.action.VIEW", (Object)SessionIntentProcessor.access$getDefaultActionViewHandler$p(this.this$0))});
            }
            {
                this.this$0 = sessionIntentProcessor;
                super(0);
            }
        }));
        SessionIntentProcessor sessionIntentProcessor = this;
        if (useDefaultHandlers) {
            map = this.getDefaultHandlers();
        } else {
            SessionIntentProcessor sessionIntentProcessor2 = sessionIntentProcessor;
            Map map2 = new LinkedHashMap();
            sessionIntentProcessor = sessionIntentProcessor2;
            map = map2;
        }
        sessionIntentProcessor.handlers = map;
    }

    public /* synthetic */ SessionIntentProcessor(SessionUseCases sessionUseCases, SessionManager sessionManager, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            bl2 = true;
        }
        this(sessionUseCases, sessionManager, bl, bl2);
    }

    @NotNull
    public static final /* synthetic */ SessionManager access$getSessionManager$p(SessionIntentProcessor $this) {
        return $this.sessionManager;
    }

    @NotNull
    public static final /* synthetic */ SessionUseCases access$getSessionUseCases$p(SessionIntentProcessor $this) {
        return $this.sessionUseCases;
    }

    public static final /* synthetic */ boolean access$getOpenNewTab$p(SessionIntentProcessor $this) {
        return $this.openNewTab;
    }

    @NotNull
    public static final /* synthetic */ Function1 access$getDefaultActionViewHandler$p(SessionIntentProcessor $this) {
        return $this.defaultActionViewHandler;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lmozilla/components/feature/session/SessionIntentProcessor$Companion;", "", "()V", "ACTIVE_SESSION_ID", "", "feature-session_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

