/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.setuid;

import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.mortbay.setuid.Group;
import org.mortbay.setuid.Passwd;
import org.mortbay.setuid.RLimit;
import org.mortbay.setuid.SetUID;

public class SetUIDServer
extends Server {
    private static final Logger LOG = Log.getLogger(SetUIDServer.class);
    private int _uid = 0;
    private int _gid = 0;
    private int _umask = -1;
    private boolean _startServerAsPrivileged;
    private RLimit _rlimitNoFiles = null;

    public void setUsername(String username) {
        Passwd passwd = SetUID.getpwnam(username);
        this._uid = passwd.getPwUid();
    }

    public String getUsername() {
        Passwd passwd = SetUID.getpwuid(this._uid);
        return passwd.getPwName();
    }

    public void setGroupname(String groupname) {
        Group group = SetUID.getgrnam(groupname);
        this._gid = group.getGrGid();
    }

    public String getGroupname() {
        Group group = SetUID.getgrgid(this._gid);
        return group.getGrName();
    }

    public int getUmask() {
        return this._umask;
    }

    public String getUmaskOctal() {
        return Integer.toOctalString(this._umask);
    }

    public void setUmask(int umask) {
        this._umask = umask;
    }

    public void setUmaskOctal(String umask) {
        this._umask = Integer.parseInt(umask, 8);
    }

    public int getUid() {
        return this._uid;
    }

    public void setUid(int uid) {
        this._uid = uid;
    }

    public void setGid(int gid) {
        this._gid = gid;
    }

    public int getGid() {
        return this._gid;
    }

    public void setRLimitNoFiles(RLimit rlimit) {
        this._rlimitNoFiles = rlimit;
    }

    public RLimit getRLimitNoFiles() {
        return this._rlimitNoFiles;
    }

    protected void doStart() throws Exception {
        if (this._umask > -1) {
            LOG.info("Setting umask=0" + Integer.toString(this._umask, 8), new Object[0]);
            SetUID.setumask(this._umask);
        }
        if (this._rlimitNoFiles != null) {
            LOG.info("Current " + SetUID.getrlimitnofiles(), new Object[0]);
            int success = SetUID.setrlimitnofiles(this._rlimitNoFiles);
            if (success < 0) {
                LOG.warn("Failed to set rlimit_nofiles, returned status " + success, new Object[0]);
            }
            LOG.info("Set " + SetUID.getrlimitnofiles(), new Object[0]);
        }
        if (this._startServerAsPrivileged) {
            super.doStart();
            if (this._gid != 0) {
                LOG.info("Setting GID=" + this._gid, new Object[0]);
                SetUID.setgid(this._gid);
            }
            if (this._uid != 0) {
                LOG.info("Setting UID=" + this._uid, new Object[0]);
                SetUID.setuid(this._uid);
                Passwd pw = SetUID.getpwuid(this._uid);
                System.setProperty("user.name", pw.getPwName());
                System.setProperty("user.home", pw.getPwDir());
            }
        } else {
            Connector[] connectors = this.getConnectors();
            for (int i = 0; connectors != null && i < connectors.length; ++i) {
                connectors[i].open();
            }
            if (this._gid != 0) {
                LOG.info("Setting GID=" + this._gid, new Object[0]);
                SetUID.setgid(this._gid);
            }
            if (this._uid != 0) {
                LOG.info("Setting UID=" + this._uid, new Object[0]);
                SetUID.setuid(this._uid);
                Passwd pw = SetUID.getpwuid(this._uid);
                System.setProperty("user.name", pw.getPwName());
                System.setProperty("user.home", pw.getPwDir());
            }
            super.doStart();
        }
    }

    public boolean isStartServerAsPrivileged() {
        return this._startServerAsPrivileged;
    }

    public void setStartServerAsPrivileged(boolean startContextsAsPrivileged) {
        this._startServerAsPrivileged = startContextsAsPrivileged;
    }
}

