/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.setuid;

import java.io.File;
import java.io.FilenameFilter;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.mortbay.setuid.Group;
import org.mortbay.setuid.Passwd;
import org.mortbay.setuid.RLimit;

public class SetUID {
    private static final Logger LOG = Log.getLogger(SetUID.class);
    public static final String __FILENAME = "libsetuid";
    public static final int OK = 0;
    public static final int ERROR = -1;

    public static native int setumask(int var0);

    public static native int setuid(int var0);

    public static native int setgid(int var0);

    public static native Passwd getpwnam(String var0) throws SecurityException;

    public static native Passwd getpwuid(int var0) throws SecurityException;

    public static native Group getgrnam(String var0) throws SecurityException;

    public static native Group getgrgid(int var0) throws SecurityException;

    public static native RLimit getrlimitnofiles();

    public static native int setrlimitnofiles(RLimit var0);

    private static void loadLibrary() {
        block15: {
            try {
                if (System.getProperty("jetty.libsetuid.path") != null) {
                    File lib = new File(System.getProperty("jetty.libsetuid.path"));
                    if (lib.exists()) {
                        System.load(lib.getCanonicalPath());
                    }
                    return;
                }
            }
            catch (Throwable e) {
                if (!LOG.isDebugEnabled()) break block15;
                LOG.debug(e);
            }
        }
        try {
            System.loadLibrary("setuid");
            return;
        }
        catch (Throwable e) {
            block17: {
                block16: {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(e);
                    }
                    try {
                        if (System.getProperty("jetty.home") != null) {
                            File lib = SetUID.getLib(new File(System.getProperty("jetty.home"), "lib/setuid/"));
                            if (lib != null && lib.exists()) {
                                System.load(lib.getCanonicalPath());
                            }
                            return;
                        }
                    }
                    catch (Throwable e2) {
                        if (!LOG.isDebugEnabled()) break block16;
                        LOG.debug(e2);
                    }
                }
                try {
                    if (System.getProperty("jetty.lib") != null) {
                        File lib = SetUID.getLib(new File(System.getProperty("jetty.lib")));
                        if (lib != null && lib.exists()) {
                            System.load(lib.getCanonicalPath());
                        }
                        return;
                    }
                }
                catch (Throwable e3) {
                    if (!LOG.isDebugEnabled()) break block17;
                    LOG.debug(e3);
                }
            }
            LOG.warn("Error: libsetuid.so could not be found", new Object[0]);
            return;
        }
    }

    private static File getLib(File dir) {
        File[] files = dir.listFiles(new LibFilenameFilter());
        if (files == null || files.length == 0) {
            return null;
        }
        File file = null;
        for (File f : files) {
            if (!f.getName().endsWith(Server.getVersion() + ".so")) continue;
            file = f;
            break;
        }
        if (file == null) {
            file = files[0];
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("setuid library " + file.getName(), new Object[0]);
        }
        return file;
    }

    private static File getLib(String dir) {
        return SetUID.getLib(new File(dir));
    }

    static {
        SetUID.loadLibrary();
    }

    private static class LibFilenameFilter
    implements FilenameFilter {
        private LibFilenameFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.toLowerCase().contains(SetUID.__FILENAME);
        }
    }
}

