/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.thread.concurrent;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.mortbay.component.LifeCycle;
import org.mortbay.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadPool
extends ThreadPoolExecutor
implements org.mortbay.thread.ThreadPool,
LifeCycle {
    public ThreadPool() {
        super(32, 256, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    }

    public ThreadPool(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, new LinkedBlockingQueue<Runnable>());
    }

    public ThreadPool(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
    }

    public ThreadPool(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, handler);
    }

    public ThreadPool(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
    }

    public ThreadPool(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
    }

    public boolean dispatch(Runnable job) {
        try {
            this.execute(job);
            return true;
        }
        catch (RejectedExecutionException e) {
            Log.warn((Throwable)e);
            return false;
        }
    }

    public int getIdleThreads() {
        return this.getPoolSize() - this.getActiveCount();
    }

    public int getThreads() {
        return this.getPoolSize();
    }

    public boolean isLowOnThreads() {
        return this.getActiveCount() >= this.getMaximumPoolSize();
    }

    public void join() throws InterruptedException {
        this.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    public boolean isFailed() {
        return false;
    }

    public boolean isRunning() {
        return !this.isTerminated() && !this.isTerminating();
    }

    public boolean isStarted() {
        return !this.isTerminated() && !this.isTerminating();
    }

    public boolean isStarting() {
        return false;
    }

    public boolean isStopped() {
        return this.isTerminated();
    }

    public boolean isStopping() {
        return this.isTerminating();
    }

    public void start() throws Exception {
        if (this.isTerminated() || this.isTerminating() || this.isShutdown()) {
            throw new IllegalStateException("Cannot restart");
        }
    }

    public void stop() throws Exception {
        super.shutdown();
        if (!super.awaitTermination(60L, TimeUnit.SECONDS)) {
            super.shutdownNow();
        }
    }
}

