/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.j2sehttpspi;

import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.mortbay.jetty.j2sehttpspi.J2SEHTTPContextHandler;
import org.mortbay.jetty.j2sehttpspi.JettyHttpContext;
import org.mortbay.jetty.j2sehttpspi.ThreadPoolExecutorAdapter;

public class JettyHttpServer
extends HttpServer {
    private static final Logger LOG = Log.getLogger(JettyHttpServer.class);
    private Server _server;
    private boolean _serverShared;
    private InetSocketAddress _addr;
    private ThreadPoolExecutor _executor;
    private Map<String, JettyHttpContext> _contexts = new HashMap<String, JettyHttpContext>();
    private Map<String, Connector> _connectors = new HashMap<String, Connector>();

    public JettyHttpServer(Server server, boolean shared) {
        this._server = server;
        this._serverShared = shared;
    }

    public void bind(InetSocketAddress addr, int backlog) throws IOException {
        Connector[] connectors = this._server.getConnectors();
        if (connectors != null) {
            for (Connector connector : connectors) {
                if (connector.getPort() != addr.getPort()) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("server already bound to port " + addr.getPort() + ", no need to rebind", new Object[0]);
                }
                return;
            }
        }
        if (this._serverShared) {
            throw new IOException("jetty server is not bound to port " + addr.getPort());
        }
        this._addr = addr;
        if (LOG.isDebugEnabled()) {
            LOG.debug("binding server to port " + addr.getPort(), new Object[0]);
        }
        SelectChannelConnector connector = new SelectChannelConnector();
        connector.setAcceptors(1);
        connector.setPort(addr.getPort());
        connector.setHost(addr.getHostName());
        this._server.addConnector((Connector)connector);
        this._connectors.put(addr.getHostName() + addr.getPort(), (Connector)connector);
    }

    public InetSocketAddress getAddress() {
        return this._addr;
    }

    public void start() {
        if (this._serverShared) {
            return;
        }
        try {
            this._server.start();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void setExecutor(Executor executor) {
        if (executor == null) {
            throw new IllegalArgumentException("missing required 'executor' argument");
        }
        if (!(executor instanceof ThreadPoolExecutor)) {
            throw new IllegalArgumentException("only java.util.concurrent.ThreadPoolExecutor instances are allowed, got: " + executor.getClass().getName());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("using ThreadPoolExecutor for server thread pool", new Object[0]);
        }
        this._executor = (ThreadPoolExecutor)executor;
        this._server.setThreadPool((ThreadPool)new ThreadPoolExecutorAdapter(this._executor));
    }

    public Executor getExecutor() {
        return this._executor;
    }

    public void stop(int delay) {
        this.cleanUpContexts();
        this.cleanUpConnectors();
        if (this._serverShared) {
            return;
        }
        try {
            this._server.stop();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void cleanUpContexts() {
        for (Map.Entry<String, JettyHttpContext> stringJettyHttpContextEntry : this._contexts.entrySet()) {
            JettyHttpContext context = stringJettyHttpContextEntry.getValue();
            this._server.removeBean((Object)context.getJettyContextHandler());
        }
        this._contexts.clear();
    }

    private void cleanUpConnectors() {
        for (Map.Entry<String, Connector> stringConnectorEntry : this._connectors.entrySet()) {
            Connector connector = stringConnectorEntry.getValue();
            try {
                connector.stop();
            }
            catch (Exception ex) {
                LOG.warn((Throwable)ex);
            }
            this._server.removeConnector(connector);
        }
        this._connectors.clear();
    }

    public HttpContext createContext(String path, HttpHandler httpHandler) {
        this.checkIfContextIsFree(path);
        JettyHttpContext context = new JettyHttpContext(this, path, httpHandler);
        J2SEHTTPContextHandler jettyContextHandler = context.getJettyContextHandler();
        ContextHandlerCollection chc = this.findContextHandlerCollection(this._server.getHandlers());
        if (chc == null) {
            throw new RuntimeException("could not find ContextHandlerCollection, you must configure one");
        }
        chc.addHandler((Handler)jettyContextHandler);
        this._contexts.put(path, context);
        return context;
    }

    private ContextHandlerCollection findContextHandlerCollection(Handler[] handlers) {
        if (handlers == null) {
            return null;
        }
        for (Handler handler : handlers) {
            HandlerCollection hc;
            ContextHandlerCollection chc;
            if (handler instanceof ContextHandlerCollection) {
                return (ContextHandlerCollection)handler;
            }
            if (!(handler instanceof HandlerCollection) || (chc = this.findContextHandlerCollection((hc = (HandlerCollection)handler).getHandlers())) == null) continue;
            return chc;
        }
        return null;
    }

    private void checkIfContextIsFree(String path) {
        ContextHandler ctx;
        Handler serverHandler = this._server.getHandler();
        if (serverHandler instanceof ContextHandler && (ctx = (ContextHandler)serverHandler).getContextPath().equals(path)) {
            throw new RuntimeException("another context already bound to path " + path);
        }
        Handler[] handlers = this._server.getHandlers();
        if (handlers == null) {
            return;
        }
        for (Handler handler : handlers) {
            ContextHandler ctx2;
            if (!(handler instanceof ContextHandler) || !(ctx2 = (ContextHandler)handler).getContextPath().equals(path)) continue;
            throw new RuntimeException("another context already bound to path " + path);
        }
    }

    public HttpContext createContext(String path) {
        return this.createContext(path, null);
    }

    public void removeContext(String path) throws IllegalArgumentException {
        JettyHttpContext context = this._contexts.remove(path);
        if (context == null) {
            return;
        }
        this._server.removeBean((Object)context.getJettyContextHandler());
    }

    public void removeContext(HttpContext context) {
        this.removeContext(context.getPath());
    }
}

