/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.j2sehttpspi;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpPrincipal;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JettyHttpExchange
extends HttpExchange {
    private HttpContext _httpContext;
    private HttpServletRequest _req;
    private HttpServletResponse _resp;
    private Headers _responseHeaders = new Headers();
    private int _responseCode = 0;
    private InputStream _is;
    private OutputStream _os;
    private HttpPrincipal _httpPrincipal;

    public JettyHttpExchange(HttpContext jaxWsContext, HttpServletRequest req, HttpServletResponse resp) {
        this._httpContext = jaxWsContext;
        this._req = req;
        this._resp = resp;
        try {
            this._is = req.getInputStream();
            this._os = resp.getOutputStream();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public Headers getRequestHeaders() {
        Headers headers = new Headers();
        Enumeration en = this._req.getHeaderNames();
        while (en.hasMoreElements()) {
            String name = (String)en.nextElement();
            Enumeration en2 = this._req.getHeaders(name);
            while (en2.hasMoreElements()) {
                String value = (String)en2.nextElement();
                headers.add(name, value);
            }
        }
        return headers;
    }

    public Headers getResponseHeaders() {
        return this._responseHeaders;
    }

    public URI getRequestURI() {
        try {
            String uriAsString = this._req.getRequestURI();
            if (this._req.getQueryString() != null) {
                uriAsString = uriAsString + "?" + this._req.getQueryString();
            }
            return new URI(uriAsString);
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
    }

    public String getRequestMethod() {
        return this._req.getMethod();
    }

    public HttpContext getHttpContext() {
        return this._httpContext;
    }

    public void close() {
        try {
            this._resp.getOutputStream().close();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public InputStream getRequestBody() {
        return this._is;
    }

    public OutputStream getResponseBody() {
        return this._os;
    }

    public void sendResponseHeaders(int rCode, long responseLength) throws IOException {
        this._responseCode = rCode;
        for (Map.Entry<String, List<String>> stringListEntry : this._responseHeaders.entrySet()) {
            String name = stringListEntry.getKey();
            List<String> values = stringListEntry.getValue();
            for (String value : values) {
                this._resp.setHeader(name, value);
            }
        }
        if (responseLength > 0L) {
            this._resp.setHeader("content-length", "" + responseLength);
        }
        this._resp.setStatus(rCode);
    }

    public InetSocketAddress getRemoteAddress() {
        return new InetSocketAddress(this._req.getRemoteAddr(), this._req.getRemotePort());
    }

    public int getResponseCode() {
        return this._responseCode;
    }

    public InetSocketAddress getLocalAddress() {
        return new InetSocketAddress(this._req.getLocalAddr(), this._req.getLocalPort());
    }

    public String getProtocol() {
        return this._req.getProtocol();
    }

    public Object getAttribute(String name) {
        return this._req.getAttribute(name);
    }

    public void setAttribute(String name, Object value) {
        this._req.setAttribute(name, value);
    }

    public void setStreams(InputStream i, OutputStream o) {
        this._is = i;
        this._os = o;
    }

    public HttpPrincipal getPrincipal() {
        return this._httpPrincipal;
    }

    public void setPrincipal(HttpPrincipal principal) {
        this._httpPrincipal = principal;
    }
}

