/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.MongoException;
import com.mongodb.ReadPreference;
import com.mongodb.ServerSession;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.Cluster;
import com.mongodb.connection.Connection;
import com.mongodb.connection.SessionContext;
import com.mongodb.internal.connection.ConcurrentPool;
import com.mongodb.internal.connection.NoOpSessionContext;
import com.mongodb.internal.validator.NoOpFieldNameValidator;
import com.mongodb.selector.ReadPreferenceServerSelector;
import com.mongodb.selector.ServerSelector;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.bson.BsonArray;
import org.bson.BsonBinary;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWriter;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.FieldNameValidator;
import org.bson.UuidRepresentation;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.Decoder;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.UuidCodec;

class ServerSessionPool {
    private static final int END_SESSIONS_BATCH_SIZE = 10000;
    private final ConcurrentPool<ServerSessionImpl> serverSessionPool = new ConcurrentPool(Integer.MAX_VALUE, (ConcurrentPool.ItemFactory)new ServerSessionItemFactory());
    private final Cluster cluster;
    private final Clock clock;
    private volatile boolean closing;
    private volatile boolean closed;
    private final List<BsonDocument> closedSessionIdentifiers = new ArrayList<BsonDocument>();

    ServerSessionPool(Cluster cluster) {
        this(cluster, new Clock(){

            @Override
            public long millis() {
                return System.currentTimeMillis();
            }
        });
    }

    ServerSessionPool(Cluster cluster, Clock clock) {
        this.cluster = cluster;
        this.clock = clock;
    }

    ServerSession get() {
        Assertions.isTrue((String)"server session pool is open", (!this.closed ? 1 : 0) != 0);
        ServerSessionImpl serverSession = (ServerSessionImpl)this.serverSessionPool.get();
        while (this.shouldPrune(serverSession)) {
            this.serverSessionPool.release((Object)serverSession, true);
            serverSession = (ServerSessionImpl)this.serverSessionPool.get();
        }
        return serverSession;
    }

    void release(ServerSession serverSession) {
        this.serverSessionPool.release((Object)((ServerSessionImpl)serverSession));
        this.serverSessionPool.prune();
    }

    void close() {
        try {
            this.closing = true;
            this.serverSessionPool.close();
            this.endClosedSessions();
        }
        finally {
            this.closed = true;
        }
    }

    private void closeSession(ServerSessionImpl serverSession) {
        serverSession.close();
        if (!this.closing) {
            return;
        }
        this.closedSessionIdentifiers.add(serverSession.getIdentifier());
        if (this.closedSessionIdentifiers.size() == 10000) {
            this.endClosedSessions();
        }
    }

    private void endClosedSessions() {
        if (this.closedSessionIdentifiers.isEmpty()) {
            return;
        }
        Connection connection = this.cluster.selectServer((ServerSelector)new ReadPreferenceServerSelector(ReadPreference.primaryPreferred())).getConnection();
        try {
            connection.command("admin", new BsonDocument("endSessions", (BsonValue)new BsonArray(this.closedSessionIdentifiers)), ReadPreference.primaryPreferred(), (FieldNameValidator)new NoOpFieldNameValidator(), (Decoder)new BsonDocumentCodec(), (SessionContext)NoOpSessionContext.INSTANCE);
        }
        catch (MongoException mongoException) {
        }
        finally {
            this.closedSessionIdentifiers.clear();
            connection.release();
        }
    }

    private boolean shouldPrune(ServerSessionImpl serverSession) {
        long oneMinuteFromTimeout;
        Integer logicalSessionTimeoutMinutes = this.cluster.getDescription().getLogicalSessionTimeoutMinutes();
        if (logicalSessionTimeoutMinutes == null) {
            return false;
        }
        long currentTimeMillis = this.clock.millis();
        long timeSinceLastUse = currentTimeMillis - serverSession.lastUsedAtMillis;
        return timeSinceLastUse > (oneMinuteFromTimeout = TimeUnit.MINUTES.toMillis(logicalSessionTimeoutMinutes - 1));
    }

    private final class ServerSessionItemFactory
    implements ConcurrentPool.ItemFactory<ServerSessionImpl> {
        private ServerSessionItemFactory() {
        }

        public ServerSessionImpl create(boolean initialize) {
            return new ServerSessionImpl(this.createNewServerSessionIdentifier());
        }

        public void close(ServerSessionImpl serverSession) {
            ServerSessionPool.this.closeSession(serverSession);
        }

        public ConcurrentPool.Prune shouldPrune(ServerSessionImpl serverSession) {
            return ServerSessionPool.this.shouldPrune(serverSession) ? ConcurrentPool.Prune.YES : ConcurrentPool.Prune.STOP;
        }

        private BsonBinary createNewServerSessionIdentifier() {
            UuidCodec uuidCodec = new UuidCodec(UuidRepresentation.STANDARD);
            BsonDocument holder = new BsonDocument();
            BsonDocumentWriter bsonDocumentWriter = new BsonDocumentWriter(holder);
            bsonDocumentWriter.writeStartDocument();
            bsonDocumentWriter.writeName("id");
            uuidCodec.encode((BsonWriter)bsonDocumentWriter, UUID.randomUUID(), EncoderContext.builder().build());
            bsonDocumentWriter.writeEndDocument();
            return holder.getBinary((Object)"id");
        }
    }

    final class ServerSessionImpl
    implements ServerSession {
        private final BsonDocument identifier;
        private int transactionNumber;
        private volatile long lastUsedAtMillis;
        private volatile boolean closed;

        ServerSessionImpl(BsonBinary identifier) {
            this.lastUsedAtMillis = ServerSessionPool.this.clock.millis();
            this.identifier = new BsonDocument("id", (BsonValue)identifier);
        }

        void close() {
            this.closed = true;
        }

        long getLastUsedAtMillis() {
            return this.lastUsedAtMillis;
        }

        int getTransactionNumber() {
            return this.transactionNumber;
        }

        @Override
        public BsonDocument getIdentifier() {
            this.lastUsedAtMillis = ServerSessionPool.this.clock.millis();
            return this.identifier;
        }

        @Override
        public long advanceTransactionNumber() {
            return this.transactionNumber++;
        }

        @Override
        public boolean isClosed() {
            return this.closed;
        }
    }

    static interface Clock {
        public long millis();
    }
}

