/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.assertions.Assertions;
import java.util.List;

public class MongoClientURI {
    private final ConnectionString proxied;
    private final MongoClientOptions.Builder builder;

    public MongoClientURI(String uri) {
        this(uri, new MongoClientOptions.Builder());
    }

    public MongoClientURI(String uri, MongoClientOptions.Builder builder) {
        this.builder = (MongoClientOptions.Builder)Assertions.notNull((String)"builder", (Object)builder);
        this.proxied = new ConnectionString(uri);
    }

    public String getUsername() {
        return this.proxied.getUsername();
    }

    public char[] getPassword() {
        return this.proxied.getPassword();
    }

    public List<String> getHosts() {
        return this.proxied.getHosts();
    }

    public String getDatabase() {
        return this.proxied.getDatabase();
    }

    public String getCollection() {
        return this.proxied.getCollection();
    }

    public String getURI() {
        return this.proxied.getConnectionString();
    }

    public MongoCredential getCredentials() {
        if (this.proxied.getCredentialList().isEmpty()) {
            return null;
        }
        return (MongoCredential)this.proxied.getCredentialList().get(0);
    }

    public MongoClientOptions getOptions() {
        if (this.proxied.getReadPreference() != null) {
            this.builder.readPreference(this.proxied.getReadPreference());
        }
        if (this.proxied.getReadConcern() != null) {
            this.builder.readConcern(this.proxied.getReadConcern());
        }
        if (this.proxied.getWriteConcern() != null) {
            this.builder.writeConcern(this.proxied.getWriteConcern());
        }
        if (this.proxied.getMaxConnectionPoolSize() != null) {
            this.builder.connectionsPerHost(this.proxied.getMaxConnectionPoolSize());
        }
        if (this.proxied.getMinConnectionPoolSize() != null) {
            this.builder.minConnectionsPerHost(this.proxied.getMinConnectionPoolSize());
        }
        if (this.proxied.getMaxWaitTime() != null) {
            this.builder.maxWaitTime(this.proxied.getMaxWaitTime());
        }
        if (this.proxied.getThreadsAllowedToBlockForConnectionMultiplier() != null) {
            this.builder.threadsAllowedToBlockForConnectionMultiplier(this.proxied.getThreadsAllowedToBlockForConnectionMultiplier());
        }
        if (this.proxied.getMaxConnectionIdleTime() != null) {
            this.builder.maxConnectionIdleTime(this.proxied.getMaxConnectionIdleTime());
        }
        if (this.proxied.getMaxConnectionLifeTime() != null) {
            this.builder.maxConnectionLifeTime(this.proxied.getMaxConnectionLifeTime());
        }
        if (this.proxied.getSocketTimeout() != null) {
            this.builder.socketTimeout(this.proxied.getSocketTimeout());
        }
        if (this.proxied.getConnectTimeout() != null) {
            this.builder.connectTimeout(this.proxied.getConnectTimeout());
        }
        if (this.proxied.getRequiredReplicaSetName() != null) {
            this.builder.requiredReplicaSetName(this.proxied.getRequiredReplicaSetName());
        }
        if (this.proxied.getSslEnabled() != null) {
            this.builder.sslEnabled(this.proxied.getSslEnabled());
        }
        if (this.proxied.getSslInvalidHostnameAllowed() != null) {
            this.builder.sslInvalidHostNameAllowed(this.proxied.getSslInvalidHostnameAllowed());
        }
        if (this.proxied.getServerSelectionTimeout() != null) {
            this.builder.serverSelectionTimeout(this.proxied.getServerSelectionTimeout());
        }
        if (this.proxied.getLocalThreshold() != null) {
            this.builder.localThreshold(this.proxied.getLocalThreshold());
        }
        if (this.proxied.getHeartbeatFrequency() != null) {
            this.builder.heartbeatFrequency(this.proxied.getHeartbeatFrequency());
        }
        if (this.proxied.getApplicationName() != null) {
            this.builder.applicationName(this.proxied.getApplicationName());
        }
        this.builder.compressorList(this.proxied.getCompressorList());
        return this.builder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MongoClientURI that = (MongoClientURI)o;
        if (!this.getHosts().equals(that.getHosts())) {
            return false;
        }
        if (this.getDatabase() != null ? !this.getDatabase().equals(that.getDatabase()) : that.getDatabase() != null) {
            return false;
        }
        if (this.getCollection() != null ? !this.getCollection().equals(that.getCollection()) : that.getCollection() != null) {
            return false;
        }
        if (this.getCredentials() != null ? !this.getCredentials().equals((Object)that.getCredentials()) : that.getCredentials() != null) {
            return false;
        }
        return this.getOptions().equals(that.getOptions());
    }

    public int hashCode() {
        int result = this.getOptions().hashCode();
        result = 31 * result + (this.getCredentials() != null ? this.getCredentials().hashCode() : 0);
        result = 31 * result + this.getHosts().hashCode();
        result = 31 * result + (this.getDatabase() != null ? this.getDatabase().hashCode() : 0);
        result = 31 * result + (this.getCollection() != null ? this.getCollection().hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.proxied.toString();
    }
}

