/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.Cursor;
import com.mongodb.CursorType;
import com.mongodb.DBCollection;
import com.mongodb.DBDecoderAdapter;
import com.mongodb.DBDecoderFactory;
import com.mongodb.DBObject;
import com.mongodb.DBObjects;
import com.mongodb.ExplainVerbosity;
import com.mongodb.Mongo;
import com.mongodb.MongoBatchCursorAdapter;
import com.mongodb.MongoNamespace;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import com.mongodb.ServerCursor;
import com.mongodb.annotations.NotThreadSafe;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.Collation;
import com.mongodb.client.model.DBCollectionCountOptions;
import com.mongodb.client.model.DBCollectionFindOptions;
import com.mongodb.operation.BatchCursor;
import com.mongodb.operation.FindOperation;
import com.mongodb.operation.OperationExecutor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.bson.BsonDocument;
import org.bson.codecs.Decoder;

@NotThreadSafe
public class DBCursor
implements Cursor,
Iterable<DBObject> {
    private final DBCollection collection;
    private final DBObject filter;
    private final DBCollectionFindOptions findOptions;
    private final OperationExecutor executor;
    private int options;
    private DBDecoderFactory decoderFactory;
    private Decoder<DBObject> decoder;
    private IteratorOrArray iteratorOrArray;
    private DBObject currentObject;
    private int numSeen;
    private boolean closed;
    private final List<DBObject> all = new ArrayList<DBObject>();
    private MongoCursor<DBObject> cursor;
    private OptionalFinalizer optionalFinalizer;

    public DBCursor(DBCollection collection, DBObject query, DBObject fields, ReadPreference readPreference) {
        this(collection, query, new DBCollectionFindOptions().projection(fields).readPreference(readPreference));
        this.addOption(collection.getOptions());
        DBObject indexKeys = DBCursor.lookupSuitableHints(query, collection.getHintFields());
        if (indexKeys != null) {
            this.hint(indexKeys);
        }
    }

    DBCursor(DBCollection collection, DBObject filter, DBCollectionFindOptions findOptions) {
        this(collection, filter, findOptions, collection.getExecutor(), collection.getDBDecoderFactory(), (Decoder<DBObject>)collection.getObjectCodec());
    }

    private DBCursor(DBCollection collection, DBObject filter, DBCollectionFindOptions findOptions, OperationExecutor executor, DBDecoderFactory decoderFactory, Decoder<DBObject> decoder) {
        this.collection = (DBCollection)Assertions.notNull((String)"collection", (Object)collection);
        this.filter = (DBObject)Assertions.notNull((String)"filter", (Object)filter);
        this.executor = (OperationExecutor)Assertions.notNull((String)"executor", (Object)executor);
        this.findOptions = (DBCollectionFindOptions)Assertions.notNull((String)"findOptions", (Object)findOptions.copy());
        this.decoderFactory = decoderFactory;
        this.decoder = (Decoder)Assertions.notNull((String)"decoder", decoder);
    }

    public DBCursor copy() {
        return new DBCursor(this.collection, this.filter, this.findOptions, this.executor, this.decoderFactory, this.decoder);
    }

    @Override
    public boolean hasNext() {
        if (this.closed) {
            throw new IllegalStateException("Cursor has been closed");
        }
        if (this.cursor == null) {
            FindOperation<DBObject> operation = this.getQueryOperation(this.decoder);
            if (operation.getCursorType() == CursorType.Tailable) {
                operation.cursorType(CursorType.TailableAwait);
            }
            this.initializeCursor(operation);
        }
        boolean hasNext = this.cursor.hasNext();
        this.setServerCursorOnFinalizer(this.cursor.getServerCursor());
        return hasNext;
    }

    @Override
    public DBObject next() {
        this.checkIteratorOrArray(IteratorOrArray.ITERATOR);
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.nextInternal();
    }

    public DBObject tryNext() {
        if (this.cursor == null) {
            FindOperation<DBObject> operation = this.getQueryOperation(this.decoder);
            if (!operation.getCursorType().isTailable()) {
                throw new IllegalArgumentException("Can only be used with a tailable cursor");
            }
            this.initializeCursor(operation);
        }
        DBObject next = this.cursor.tryNext();
        this.setServerCursorOnFinalizer(this.cursor.getServerCursor());
        return this.currentObject(next);
    }

    public DBObject curr() {
        return this.currentObject;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public DBCursor addOption(int option) {
        this.setOptions(this.options |= option);
        return this;
    }

    public DBCursor setOptions(int options) {
        if ((options & 0x40) != 0) {
            throw new UnsupportedOperationException("exhaust query option is not supported");
        }
        this.options = options;
        return this;
    }

    public DBCursor resetOptions() {
        this.options = 0;
        return this;
    }

    public int getOptions() {
        return this.options;
    }

    public int getLimit() {
        return this.findOptions.getLimit();
    }

    public int getBatchSize() {
        return this.findOptions.getBatchSize();
    }

    public DBCursor addSpecial(String name, Object value) {
        if (name == null || value == null) {
            return this;
        }
        if ("$comment".equals(name)) {
            this.comment(value.toString());
        } else if ("$explain".equals(name)) {
            this.findOptions.getModifiers().put("$explain", true);
        } else if ("$hint".equals(name)) {
            if (value instanceof String) {
                this.hint((String)value);
            } else {
                this.hint((DBObject)value);
            }
        } else if ("$maxScan".equals(name)) {
            this.maxScan(((Number)value).intValue());
        } else if ("$maxTimeMS".equals(name)) {
            this.maxTime(((Number)value).longValue(), TimeUnit.MILLISECONDS);
        } else if ("$max".equals(name)) {
            this.max((DBObject)value);
        } else if ("$min".equals(name)) {
            this.min((DBObject)value);
        } else if ("$orderby".equals(name)) {
            this.sort((DBObject)value);
        } else if ("$returnKey".equals(name)) {
            this.returnKey();
        } else if ("$showDiskLoc".equals(name)) {
            this.showDiskLoc();
        } else if ("$snapshot".equals(name)) {
            this.snapshot();
        } else if ("$natural".equals(name)) {
            this.sort(new BasicDBObject("$natural", (Object)((Number)value).intValue()));
        } else {
            throw new IllegalArgumentException(name + "is not a supported modifier");
        }
        return this;
    }

    public DBCursor comment(String comment) {
        this.findOptions.getModifiers().put("$comment", comment);
        return this;
    }

    public DBCursor maxScan(int max) {
        this.findOptions.getModifiers().put("$maxScan", max);
        return this;
    }

    public DBCursor max(DBObject max) {
        this.findOptions.getModifiers().put("$max", max);
        return this;
    }

    public DBCursor min(DBObject min) {
        this.findOptions.getModifiers().put("$min", min);
        return this;
    }

    public DBCursor returnKey() {
        this.findOptions.getModifiers().put("$returnKey", true);
        return this;
    }

    public DBCursor showDiskLoc() {
        this.findOptions.getModifiers().put("$showDiskLoc", true);
        return this;
    }

    public DBCursor hint(DBObject indexKeys) {
        this.findOptions.getModifiers().put("$hint", indexKeys);
        return this;
    }

    public DBCursor hint(String indexName) {
        this.findOptions.getModifiers().put("$hint", indexName);
        return this;
    }

    public DBCursor maxTime(long maxTime, TimeUnit timeUnit) {
        this.findOptions.maxTime(maxTime, timeUnit);
        return this;
    }

    public DBCursor snapshot() {
        this.findOptions.getModifiers().put("$snapshot", true);
        return this;
    }

    public DBObject explain() {
        return DBObjects.toDBObject((BsonDocument)this.executor.execute(this.getQueryOperation((Decoder<DBObject>)this.collection.getObjectCodec()).asExplainableOperation(ExplainVerbosity.QUERY_PLANNER), this.getReadPreference()));
    }

    private FindOperation<DBObject> getQueryOperation(Decoder<DBObject> decoder) {
        FindOperation operation = new FindOperation(this.collection.getNamespace(), decoder).readConcern(this.getReadConcern()).filter(this.collection.wrapAllowNull(this.filter)).batchSize(this.findOptions.getBatchSize()).skip(this.findOptions.getSkip()).limit(this.findOptions.getLimit()).maxTime(this.findOptions.getMaxTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS).modifiers(this.collection.wrapAllowNull(this.findOptions.getModifiers())).projection(this.collection.wrapAllowNull(this.findOptions.getProjection())).sort(this.collection.wrapAllowNull(this.findOptions.getSort())).noCursorTimeout(this.findOptions.isNoCursorTimeout()).oplogReplay(this.findOptions.isOplogReplay()).partial(this.findOptions.isPartial()).collation(this.findOptions.getCollation());
        if ((this.options & 2) != 0) {
            if ((this.options & 0x20) != 0) {
                operation.cursorType(CursorType.TailableAwait);
            } else {
                operation.cursorType(CursorType.Tailable);
            }
        }
        if ((this.options & 8) != 0) {
            operation.oplogReplay(true);
        }
        if ((this.options & 0x10) != 0) {
            operation.noCursorTimeout(true);
        }
        if ((this.options & 0x80) != 0) {
            operation.partial(true);
        }
        return operation;
    }

    public DBCursor sort(DBObject orderBy) {
        this.findOptions.sort(orderBy);
        return this;
    }

    public DBCursor limit(int limit) {
        this.findOptions.limit(limit);
        return this;
    }

    public DBCursor batchSize(int numberOfElements) {
        this.findOptions.batchSize(numberOfElements);
        return this;
    }

    public DBCursor skip(int numberOfElements) {
        this.findOptions.skip(numberOfElements);
        return this;
    }

    @Override
    public long getCursorId() {
        if (this.cursor != null && this.cursor.getServerCursor() != null) {
            return this.cursor.getServerCursor().getId();
        }
        return 0L;
    }

    public int numSeen() {
        return this.numSeen;
    }

    @Override
    public void close() {
        this.closed = true;
        if (this.cursor != null) {
            this.cursor.close();
            this.cursor = null;
            this.setServerCursorOnFinalizer(null);
        }
        this.currentObject = null;
    }

    @Deprecated
    public DBCursor slaveOk() {
        return this.addOption(4);
    }

    @Override
    public Iterator<DBObject> iterator() {
        return this.copy();
    }

    public List<DBObject> toArray() {
        return this.toArray(Integer.MAX_VALUE);
    }

    public List<DBObject> toArray(int max) {
        this.checkIteratorOrArray(IteratorOrArray.ARRAY);
        this.fillArray(max - 1);
        return this.all;
    }

    public int count() {
        DBCollectionCountOptions countOptions = this.getDbCollectionCountOptions();
        return (int)this.collection.getCount(this.getQuery(), countOptions);
    }

    public DBObject one() {
        DBCursor findOneCursor = this.copy().limit(-1);
        return findOneCursor.hasNext() ? findOneCursor.next() : null;
    }

    public int length() {
        this.checkIteratorOrArray(IteratorOrArray.ARRAY);
        this.fillArray(Integer.MAX_VALUE);
        return this.all.size();
    }

    public int itcount() {
        int n = 0;
        while (this.hasNext()) {
            this.next();
            ++n;
        }
        return n;
    }

    public int size() {
        DBCollectionCountOptions countOptions = this.getDbCollectionCountOptions().skip(this.findOptions.getSkip()).limit(this.findOptions.getLimit());
        return (int)this.collection.getCount(this.getQuery(), countOptions);
    }

    public DBObject getKeysWanted() {
        return this.findOptions.getProjection();
    }

    public DBObject getQuery() {
        return this.filter;
    }

    public DBCollection getCollection() {
        return this.collection;
    }

    @Override
    public ServerAddress getServerAddress() {
        if (this.cursor != null) {
            return this.cursor.getServerAddress();
        }
        return null;
    }

    public DBCursor setReadPreference(ReadPreference readPreference) {
        this.findOptions.readPreference(readPreference);
        return this;
    }

    public ReadPreference getReadPreference() {
        if (this.findOptions.getReadPreference() != null) {
            return this.findOptions.getReadPreference();
        }
        return this.collection.getReadPreference();
    }

    DBCursor setReadConcern(ReadConcern readConcern) {
        this.findOptions.readConcern(readConcern);
        return this;
    }

    ReadConcern getReadConcern() {
        if (this.findOptions.getReadConcern() != null) {
            return this.findOptions.getReadConcern();
        }
        return this.collection.getReadConcern();
    }

    public Collation getCollation() {
        return this.findOptions.getCollation();
    }

    public DBCursor setCollation(Collation collation) {
        this.findOptions.collation(collation);
        return this;
    }

    public DBCursor setDecoderFactory(DBDecoderFactory factory) {
        this.decoderFactory = factory;
        this.decoder = new DBDecoderAdapter(factory.create(), this.collection, this.getCollection().getBufferPool());
        return this;
    }

    public DBDecoderFactory getDecoderFactory() {
        return this.decoderFactory;
    }

    public String toString() {
        return "DBCursor{collection=" + this.collection + ", find=" + this.findOptions + (this.cursor != null ? ", cursor=" + this.cursor.getServerCursor() : "") + '}';
    }

    private void initializeCursor(FindOperation<DBObject> operation) {
        this.cursor = new MongoBatchCursorAdapter<DBObject>((BatchCursor)this.executor.execute(operation, this.getReadPreferenceForCursor()));
        if (this.isCursorFinalizerEnabled() && this.cursor.getServerCursor() != null) {
            this.optionalFinalizer = new OptionalFinalizer(this.collection.getDB().getMongo(), this.collection.getNamespace());
        }
    }

    private boolean isCursorFinalizerEnabled() {
        return this.collection.getDB().getMongo().getMongoClientOptions().isCursorFinalizerEnabled();
    }

    private void setServerCursorOnFinalizer(ServerCursor serverCursor) {
        if (this.optionalFinalizer != null) {
            this.optionalFinalizer.setServerCursor(serverCursor);
        }
    }

    private void checkIteratorOrArray(IteratorOrArray expected) {
        if (this.iteratorOrArray == null) {
            this.iteratorOrArray = expected;
            return;
        }
        if (expected == this.iteratorOrArray) {
            return;
        }
        throw new IllegalArgumentException("Can't switch cursor access methods");
    }

    private ReadPreference getReadPreferenceForCursor() {
        ReadPreference readPreference = this.getReadPreference();
        if ((this.options & 4) != 0 && !readPreference.isSlaveOk()) {
            readPreference = ReadPreference.secondaryPreferred();
        }
        return readPreference;
    }

    private void fillArray(int n) {
        this.checkIteratorOrArray(IteratorOrArray.ARRAY);
        while (n >= this.all.size() && this.hasNext()) {
            this.all.add(this.nextInternal());
        }
    }

    private DBObject nextInternal() {
        if (this.iteratorOrArray == null) {
            this.checkIteratorOrArray(IteratorOrArray.ITERATOR);
        }
        DBObject next = this.cursor.next();
        this.setServerCursorOnFinalizer(this.cursor.getServerCursor());
        return this.currentObject(next);
    }

    private DBObject currentObject(DBObject newCurrentObject) {
        if (newCurrentObject != null) {
            this.currentObject = newCurrentObject;
            ++this.numSeen;
            if (this.findOptions.getProjection() != null && !this.findOptions.getProjection().keySet().isEmpty()) {
                this.currentObject.markAsPartialObject();
            }
        }
        return newCurrentObject;
    }

    private static DBObject lookupSuitableHints(DBObject query, List<DBObject> hints) {
        if (hints == null) {
            return null;
        }
        Set<String> keys = query.keySet();
        for (DBObject hint : hints) {
            if (!keys.containsAll(hint.keySet())) continue;
            return hint;
        }
        return null;
    }

    private DBCollectionCountOptions getDbCollectionCountOptions() {
        DBCollectionCountOptions countOptions = new DBCollectionCountOptions().readPreference(this.getReadPreferenceForCursor()).readConcern(this.getReadConcern()).collation(this.getCollation()).maxTime(this.findOptions.getMaxTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
        Object hint = this.findOptions.getModifiers().get("$hint");
        if (hint != null) {
            if (hint instanceof String) {
                countOptions.hintString((String)hint);
            } else {
                countOptions.hint((DBObject)hint);
            }
        }
        return countOptions;
    }

    private static class OptionalFinalizer {
        private final Mongo mongo;
        private final MongoNamespace namespace;
        private volatile ServerCursor serverCursor;

        private OptionalFinalizer(Mongo mongo, MongoNamespace namespace) {
            this.namespace = (MongoNamespace)Assertions.notNull((String)"namespace", (Object)namespace);
            this.mongo = (Mongo)Assertions.notNull((String)"mongo", (Object)mongo);
        }

        private void setServerCursor(ServerCursor serverCursor) {
            this.serverCursor = serverCursor;
        }

        protected void finalize() {
            if (this.serverCursor != null) {
                this.mongo.addOrphanedCursor(this.serverCursor, this.namespace);
            }
        }
    }

    private static enum IteratorOrArray {
        ITERATOR,
        ARRAY;

    }
}

