/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.Block;
import com.mongodb.Function;
import com.mongodb.MongoNamespace;
import com.mongodb.OperationIterable;
import com.mongodb.ReadPreference;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.ListIndexesFluent;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoIterable;
import com.mongodb.operation.ListIndexesOperation;
import com.mongodb.operation.OperationExecutor;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.bson.codecs.Codec;
import org.bson.codecs.configuration.CodecRegistry;

final class ListIndexesFluentImpl<T>
implements ListIndexesFluent<T> {
    private final MongoNamespace namespace;
    private final Class<T> clazz;
    private final ReadPreference readPreference;
    private final CodecRegistry codecRegistry;
    private final OperationExecutor executor;
    private int batchSize;
    private long maxTimeMS;

    ListIndexesFluentImpl(MongoNamespace namespace, Class<T> clazz, CodecRegistry codecRegistry, ReadPreference readPreference, OperationExecutor executor) {
        this.namespace = (MongoNamespace)Assertions.notNull((String)"namespace", (Object)namespace);
        this.clazz = (Class)Assertions.notNull((String)"clazz", clazz);
        this.codecRegistry = (CodecRegistry)Assertions.notNull((String)"codecRegistry", (Object)codecRegistry);
        this.readPreference = (ReadPreference)Assertions.notNull((String)"readPreference", (Object)readPreference);
        this.executor = (OperationExecutor)Assertions.notNull((String)"executor", (Object)executor);
    }

    @Override
    public ListIndexesFluent<T> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull((String)"timeUnit", (Object)((Object)timeUnit));
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    @Override
    public ListIndexesFluent<T> batchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    @Override
    public MongoCursor<T> iterator() {
        return this.execute().iterator();
    }

    @Override
    public T first() {
        return this.execute().first();
    }

    @Override
    public <U> MongoIterable<U> map(Function<T, U> mapper) {
        return this.execute().map(mapper);
    }

    @Override
    public void forEach(Block<? super T> block) {
        this.execute().forEach(block);
    }

    @Override
    public <A extends Collection<? super T>> A into(A target) {
        return this.execute().into(target);
    }

    private MongoIterable<T> execute() {
        return new OperationIterable(this.createListIndexesOperation(), this.readPreference, this.executor);
    }

    private <C> Codec<C> getCodec(Class<C> clazz) {
        return this.codecRegistry.get(clazz);
    }

    private ListIndexesOperation<T> createListIndexesOperation() {
        return new ListIndexesOperation(this.namespace, this.getCodec(this.clazz)).batchSize(this.batchSize).maxTime(this.maxTimeMS, TimeUnit.MILLISECONDS);
    }
}

