/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.internal;

import com.mongodb.MongoClientException;
import com.mongodb.MongoException;
import com.mongodb.MongoInternalException;
import com.mongodb.MongoInterruptedException;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.MongoClient;
import com.mongodb.client.internal.CollectionInfoRetriever;
import com.mongodb.client.internal.CommandMarker;
import com.mongodb.client.internal.KeyManagementService;
import com.mongodb.client.internal.KeyRetriever;
import com.mongodb.client.model.vault.DataKeyOptions;
import com.mongodb.client.model.vault.EncryptOptions;
import com.mongodb.client.model.vault.RewrapManyDataKeyOptions;
import com.mongodb.crypt.capi.MongoCryptException;
import com.mongodb.internal.capi.MongoCryptHelper;
import com.mongodb.internal.client.vault.EncryptOptionsHelper;
import com.mongodb.internal.crypt.capi.MongoCrypt;
import com.mongodb.internal.crypt.capi.MongoCryptContext;
import com.mongodb.internal.crypt.capi.MongoDataKeyOptions;
import com.mongodb.internal.crypt.capi.MongoKeyDecryptor;
import com.mongodb.internal.crypt.capi.MongoRewrapManyDataKeyOptions;
import com.mongodb.internal.thread.InterruptionUtil;
import com.mongodb.internal.time.Timeout;
import com.mongodb.lang.Nullable;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.bson.BsonBinary;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.RawBsonDocument;

public class Crypt
implements Closeable {
    private static final RawBsonDocument EMPTY_RAW_BSON_DOCUMENT = RawBsonDocument.parse((String)"{}");
    private final MongoCrypt mongoCrypt;
    private final Map<String, Map<String, Object>> kmsProviders;
    private final Map<String, Supplier<Map<String, Object>>> kmsProviderPropertySuppliers;
    private final CollectionInfoRetriever collectionInfoRetriever;
    private final CommandMarker commandMarker;
    private final KeyRetriever keyRetriever;
    private final KeyManagementService keyManagementService;
    private final boolean bypassAutoEncryption;
    @Nullable
    private final MongoClient collectionInfoRetrieverClient;
    @Nullable
    private final MongoClient keyVaultClient;

    Crypt(MongoCrypt mongoCrypt, KeyRetriever keyRetriever, KeyManagementService keyManagementService, Map<String, Map<String, Object>> kmsProviders, Map<String, Supplier<Map<String, Object>>> kmsProviderPropertySuppliers) {
        this(mongoCrypt, keyRetriever, keyManagementService, kmsProviders, kmsProviderPropertySuppliers, false, null, null, null, null);
    }

    Crypt(MongoCrypt mongoCrypt, KeyRetriever keyRetriever, KeyManagementService keyManagementService, Map<String, Map<String, Object>> kmsProviders, Map<String, Supplier<Map<String, Object>>> kmsProviderPropertySuppliers, boolean bypassAutoEncryption, @Nullable CollectionInfoRetriever collectionInfoRetriever, @Nullable CommandMarker commandMarker, @Nullable MongoClient collectionInfoRetrieverClient, @Nullable MongoClient keyVaultClient) {
        this.mongoCrypt = mongoCrypt;
        this.keyRetriever = keyRetriever;
        this.keyManagementService = keyManagementService;
        this.kmsProviders = kmsProviders;
        this.kmsProviderPropertySuppliers = kmsProviderPropertySuppliers;
        this.bypassAutoEncryption = bypassAutoEncryption;
        this.collectionInfoRetriever = collectionInfoRetriever;
        this.commandMarker = commandMarker;
        this.collectionInfoRetrieverClient = collectionInfoRetrieverClient;
        this.keyVaultClient = keyVaultClient;
    }

    RawBsonDocument encrypt(String databaseName, RawBsonDocument command, @Nullable Timeout timeout) {
        RawBsonDocument rawBsonDocument;
        block9: {
            Assertions.notNull((String)"databaseName", (Object)databaseName);
            Assertions.notNull((String)"command", (Object)command);
            if (this.bypassAutoEncryption) {
                return command;
            }
            MongoCryptContext encryptionContext = this.mongoCrypt.createEncryptionContext(databaseName, (BsonDocument)command);
            try {
                rawBsonDocument = this.executeStateMachine(encryptionContext, databaseName, timeout);
                if (encryptionContext == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (encryptionContext != null) {
                        try {
                            encryptionContext.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (MongoCryptException e) {
                    throw this.wrapInMongoException(e);
                }
            }
            encryptionContext.close();
        }
        return rawBsonDocument;
    }

    RawBsonDocument decrypt(RawBsonDocument commandResponse, @Nullable Timeout timeoutOperation) {
        RawBsonDocument rawBsonDocument;
        block8: {
            Assertions.notNull((String)"commandResponse", (Object)commandResponse);
            MongoCryptContext decryptionContext = this.mongoCrypt.createDecryptionContext((BsonDocument)commandResponse);
            try {
                rawBsonDocument = this.executeStateMachine(decryptionContext, null, timeoutOperation);
                if (decryptionContext == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (decryptionContext != null) {
                        try {
                            decryptionContext.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (MongoCryptException e) {
                    throw this.wrapInMongoException(e);
                }
            }
            decryptionContext.close();
        }
        return rawBsonDocument;
    }

    BsonDocument createDataKey(String kmsProvider, DataKeyOptions options, @Nullable Timeout operationTimeout) {
        RawBsonDocument rawBsonDocument;
        block8: {
            Assertions.notNull((String)"kmsProvider", (Object)kmsProvider);
            Assertions.notNull((String)"options", (Object)options);
            MongoCryptContext dataKeyCreationContext = this.mongoCrypt.createDataKeyContext(kmsProvider, MongoDataKeyOptions.builder().keyAltNames(options.getKeyAltNames()).masterKey(options.getMasterKey()).keyMaterial(options.getKeyMaterial()).build());
            try {
                rawBsonDocument = this.executeStateMachine(dataKeyCreationContext, null, operationTimeout);
                if (dataKeyCreationContext == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (dataKeyCreationContext != null) {
                        try {
                            dataKeyCreationContext.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (MongoCryptException e) {
                    throw this.wrapInMongoException(e);
                }
            }
            dataKeyCreationContext.close();
        }
        return rawBsonDocument;
    }

    BsonBinary encryptExplicitly(BsonValue value, EncryptOptions options, @Nullable Timeout timeoutOperation) {
        BsonBinary bsonBinary;
        block8: {
            Assertions.notNull((String)"value", (Object)value);
            Assertions.notNull((String)"options", (Object)options);
            MongoCryptContext encryptionContext = this.mongoCrypt.createExplicitEncryptionContext(new BsonDocument("v", value), EncryptOptionsHelper.asMongoExplicitEncryptOptions((EncryptOptions)options));
            try {
                bsonBinary = this.executeStateMachine(encryptionContext, null, timeoutOperation).getBinary((Object)"v");
                if (encryptionContext == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (encryptionContext != null) {
                        try {
                            encryptionContext.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (MongoCryptException e) {
                    throw this.wrapInMongoException(e);
                }
            }
            encryptionContext.close();
        }
        return bsonBinary;
    }

    BsonDocument encryptExpression(BsonDocument expression, EncryptOptions options, @Nullable Timeout timeoutOperation) {
        BsonDocument bsonDocument;
        block8: {
            Assertions.notNull((String)"expression", (Object)expression);
            Assertions.notNull((String)"options", (Object)options);
            MongoCryptContext encryptionContext = this.mongoCrypt.createEncryptExpressionContext(new BsonDocument("v", (BsonValue)expression), EncryptOptionsHelper.asMongoExplicitEncryptOptions((EncryptOptions)options));
            try {
                bsonDocument = this.executeStateMachine(encryptionContext, null, timeoutOperation).getDocument((Object)"v");
                if (encryptionContext == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (encryptionContext != null) {
                        try {
                            encryptionContext.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (MongoCryptException e) {
                    throw this.wrapInMongoException(e);
                }
            }
            encryptionContext.close();
        }
        return bsonDocument;
    }

    BsonValue decryptExplicitly(BsonBinary value, @Nullable Timeout timeoutOperation) {
        BsonValue bsonValue;
        block8: {
            Assertions.notNull((String)"value", (Object)value);
            MongoCryptContext decryptionContext = this.mongoCrypt.createExplicitDecryptionContext(new BsonDocument("v", (BsonValue)value));
            try {
                bsonValue = (BsonValue)Assertions.assertNotNull((Object)this.executeStateMachine(decryptionContext, null, timeoutOperation).get((Object)"v"));
                if (decryptionContext == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (decryptionContext != null) {
                        try {
                            decryptionContext.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (MongoCryptException e) {
                    throw this.wrapInMongoException(e);
                }
            }
            decryptionContext.close();
        }
        return bsonValue;
    }

    BsonDocument rewrapManyDataKey(BsonDocument filter, RewrapManyDataKeyOptions options, @Nullable Timeout operationTimeout) {
        RawBsonDocument rawBsonDocument;
        block8: {
            Assertions.notNull((String)"filter", (Object)filter);
            MongoCryptContext rewrapManyDatakeyContext = this.mongoCrypt.createRewrapManyDatakeyContext(filter, MongoRewrapManyDataKeyOptions.builder().provider(options.getProvider()).masterKey(options.getMasterKey()).build());
            try {
                rawBsonDocument = this.executeStateMachine(rewrapManyDatakeyContext, null, operationTimeout);
                if (rewrapManyDatakeyContext == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (rewrapManyDatakeyContext != null) {
                        try {
                            rewrapManyDatakeyContext.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (MongoCryptException e) {
                    throw this.wrapInMongoException(e);
                }
            }
            rewrapManyDatakeyContext.close();
        }
        return rawBsonDocument;
    }

    @Override
    public void close() {
        try (MongoCrypt ignored = this.mongoCrypt;
             CommandMarker ignored1 = this.commandMarker;
             MongoClient ignored2 = this.collectionInfoRetrieverClient;){
            MongoClient ignored3 = this.keyVaultClient;
            if (ignored3 != null) {
                ignored3.close();
            }
        }
    }

    private RawBsonDocument executeStateMachine(MongoCryptContext cryptContext, @Nullable String databaseName, @Nullable Timeout timeout) {
        MongoCryptContext.State state;
        block9: while (true) {
            state = cryptContext.getState();
            switch (state) {
                case NEED_MONGO_COLLINFO: {
                    this.collInfo(cryptContext, (String)Assertions.notNull((String)"databaseName", (Object)databaseName), timeout);
                    continue block9;
                }
                case NEED_MONGO_MARKINGS: {
                    this.mark(cryptContext, (String)Assertions.notNull((String)"databaseName", (Object)databaseName), timeout);
                    continue block9;
                }
                case NEED_KMS_CREDENTIALS: {
                    this.fetchCredentials(cryptContext);
                    continue block9;
                }
                case NEED_MONGO_KEYS: {
                    this.fetchKeys(cryptContext, timeout);
                    continue block9;
                }
                case NEED_KMS: {
                    this.decryptKeys(cryptContext, timeout);
                    continue block9;
                }
                case READY: {
                    return cryptContext.finish();
                }
                case DONE: {
                    return EMPTY_RAW_BSON_DOCUMENT;
                }
            }
            break;
        }
        throw new MongoInternalException("Unsupported encryptor state + " + state);
    }

    private void fetchCredentials(MongoCryptContext cryptContext) {
        cryptContext.provideKmsProviderCredentials(MongoCryptHelper.fetchCredentials(this.kmsProviders, this.kmsProviderPropertySuppliers));
    }

    private void collInfo(MongoCryptContext cryptContext, String databaseName, @Nullable Timeout operationTimeout) {
        try {
            List<BsonDocument> results = ((CollectionInfoRetriever)Assertions.assertNotNull((Object)this.collectionInfoRetriever)).filter(databaseName, (BsonDocument)cryptContext.getMongoOperation(), operationTimeout);
            for (BsonDocument result : results) {
                cryptContext.addMongoOperationResult(result);
            }
            cryptContext.completeMongoOperation();
        }
        catch (Throwable t) {
            throw MongoException.fromThrowableNonNull((Throwable)t);
        }
    }

    private void mark(MongoCryptContext cryptContext, String databaseName, @Nullable Timeout timeout) {
        try {
            RawBsonDocument markedCommand = ((CommandMarker)Assertions.assertNotNull((Object)this.commandMarker)).mark(databaseName, cryptContext.getMongoOperation(), timeout);
            cryptContext.addMongoOperationResult((BsonDocument)markedCommand);
            cryptContext.completeMongoOperation();
        }
        catch (Throwable t) {
            throw this.wrapInMongoException(t);
        }
    }

    private void fetchKeys(MongoCryptContext keyBroker, @Nullable Timeout operationTimeout) {
        try {
            for (BsonDocument bsonDocument : this.keyRetriever.find((BsonDocument)keyBroker.getMongoOperation(), operationTimeout)) {
                keyBroker.addMongoOperationResult(bsonDocument);
            }
            keyBroker.completeMongoOperation();
        }
        catch (Throwable t) {
            throw MongoException.fromThrowableNonNull((Throwable)t);
        }
    }

    private void decryptKeys(MongoCryptContext cryptContext, @Nullable Timeout operationTimeout) {
        try {
            MongoKeyDecryptor keyDecryptor = cryptContext.nextKeyDecryptor();
            while (keyDecryptor != null) {
                this.decryptKey(keyDecryptor, operationTimeout);
                keyDecryptor = cryptContext.nextKeyDecryptor();
            }
            cryptContext.completeKeyDecryptors();
        }
        catch (Throwable t) {
            throw (MongoInterruptedException)InterruptionUtil.translateInterruptedException((Throwable)t, (String)"Interrupted while doing IO").orElseThrow(() -> this.wrapInMongoException(t));
        }
    }

    private void decryptKey(MongoKeyDecryptor keyDecryptor, @Nullable Timeout operationTimeout) throws IOException {
        try (InputStream inputStream = this.keyManagementService.stream(keyDecryptor.getKmsProvider(), keyDecryptor.getHostName(), keyDecryptor.getMessage(), operationTimeout);){
            int bytesNeeded = keyDecryptor.bytesNeeded();
            while (bytesNeeded > 0) {
                byte[] bytes = new byte[bytesNeeded];
                int bytesRead = inputStream.read(bytes, 0, bytes.length);
                keyDecryptor.feed(ByteBuffer.wrap(bytes, 0, bytesRead));
                bytesNeeded = keyDecryptor.bytesNeeded();
            }
        }
    }

    private MongoException wrapInMongoException(Throwable t) {
        if (t instanceof MongoException) {
            return (MongoException)t;
        }
        return new MongoClientException("Exception in encryption library: " + t.getMessage(), t);
    }
}

