/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.internal;

import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ClusterType;
import com.mongodb.connection.ServerDescription;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.async.function.AsyncCallbackFunction;
import com.mongodb.internal.binding.AbstractReferenceCounted;
import com.mongodb.internal.binding.AsyncClusterAwareReadWriteBinding;
import com.mongodb.internal.binding.AsyncConnectionSource;
import com.mongodb.internal.binding.AsyncReadWriteBinding;
import com.mongodb.internal.binding.ReferenceCounted;
import com.mongodb.internal.binding.TransactionContext;
import com.mongodb.internal.connection.AsyncConnection;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.session.ClientSessionContext;
import com.mongodb.lang.Nullable;
import com.mongodb.reactivestreams.client.ClientSession;
import org.bson.BsonTimestamp;

public class ClientSessionBinding
extends AbstractReferenceCounted
implements AsyncReadWriteBinding {
    private final AsyncClusterAwareReadWriteBinding wrapped;
    private final ClientSession session;
    private final boolean ownsSession;

    public ClientSessionBinding(ClientSession session, boolean ownsSession, AsyncClusterAwareReadWriteBinding wrapped) {
        this.wrapped = ((AsyncClusterAwareReadWriteBinding)Assertions.notNull((String)"wrapped", (Object)wrapped)).retain();
        this.ownsSession = ownsSession;
        this.session = (ClientSession)Assertions.notNull((String)"session", (Object)session);
    }

    public ReadPreference getReadPreference() {
        return this.wrapped.getReadPreference();
    }

    public void getReadConnectionSource(OperationContext operationContext, SingleResultCallback<AsyncConnectionSource> callback) {
        this.getConnectionSource((AsyncCallbackFunction<OperationContext, AsyncConnectionSource>)((AsyncCallbackFunction)(arg_0, arg_1) -> ((AsyncClusterAwareReadWriteBinding)this.wrapped).getReadConnectionSource(arg_0, arg_1)), operationContext, callback);
    }

    public void getReadConnectionSource(int minWireVersion, ReadPreference fallbackReadPreference, OperationContext operationContext, SingleResultCallback<AsyncConnectionSource> callback) {
        this.getConnectionSource((AsyncCallbackFunction<OperationContext, AsyncConnectionSource>)((AsyncCallbackFunction)(opContext, wrappedConnectionSourceCallback) -> this.wrapped.getReadConnectionSource(minWireVersion, fallbackReadPreference, opContext, wrappedConnectionSourceCallback)), operationContext, callback);
    }

    public void getWriteConnectionSource(OperationContext operationContext, SingleResultCallback<AsyncConnectionSource> callback) {
        this.getConnectionSource((AsyncCallbackFunction<OperationContext, AsyncConnectionSource>)((AsyncCallbackFunction)(arg_0, arg_1) -> ((AsyncClusterAwareReadWriteBinding)this.wrapped).getWriteConnectionSource(arg_0, arg_1)), operationContext, callback);
    }

    private void getConnectionSource(AsyncCallbackFunction<OperationContext, AsyncConnectionSource> connectionSourceSupplier, OperationContext operationContext, SingleResultCallback<AsyncConnectionSource> callback) {
        WrappingCallback wrappingCallback = new WrappingCallback(callback);
        if (!this.session.hasActiveTransaction()) {
            connectionSourceSupplier.apply((Object)operationContext, (SingleResultCallback)wrappingCallback);
            return;
        }
        if (TransactionContext.get((com.mongodb.session.ClientSession)this.session) == null) {
            connectionSourceSupplier.apply((Object)operationContext, (source, t) -> {
                if (t != null) {
                    wrappingCallback.onResult(null, t);
                } else {
                    ClusterType clusterType = ((AsyncConnectionSource)Assertions.assertNotNull((Object)source)).getServerDescription().getClusterType();
                    if (clusterType == ClusterType.SHARDED || clusterType == ClusterType.LOAD_BALANCED) {
                        TransactionContext transactionContext = new TransactionContext(clusterType);
                        this.session.setTransactionContext(source.getServerDescription().getAddress(), transactionContext);
                        transactionContext.release();
                    }
                    wrappingCallback.onResult((AsyncConnectionSource)source, (Throwable)null);
                }
            });
        } else {
            this.wrapped.getConnectionSource((ServerAddress)Assertions.assertNotNull((Object)this.session.getPinnedServerAddress()), operationContext, (SingleResultCallback)wrappingCallback);
        }
    }

    public AsyncReadWriteBinding retain() {
        super.retain();
        return this;
    }

    public int release() {
        int count = super.release();
        if (count == 0) {
            this.wrapped.release();
            if (this.ownsSession) {
                this.session.close();
            }
        }
        return count;
    }

    private class WrappingCallback
    implements SingleResultCallback<AsyncConnectionSource> {
        private final SingleResultCallback<AsyncConnectionSource> callback;

        WrappingCallback(SingleResultCallback<AsyncConnectionSource> callback) {
            this.callback = callback;
        }

        public void onResult(@Nullable AsyncConnectionSource result, @Nullable Throwable t) {
            if (t != null) {
                this.callback.onResult(null, t);
            } else {
                this.callback.onResult((Object)new SessionBindingAsyncConnectionSource((AsyncConnectionSource)Assertions.assertNotNull((Object)result)), null);
            }
        }
    }

    public static final class AsyncClientSessionContext
    extends ClientSessionContext {
        private final ClientSession clientSession;
        private final ReadConcern inheritedReadConcern;
        private final boolean ownsSession;

        AsyncClientSessionContext(ClientSession clientSession, boolean ownsSession, ReadConcern inheritedReadConcern) {
            super((com.mongodb.session.ClientSession)clientSession);
            this.clientSession = clientSession;
            this.ownsSession = ownsSession;
            this.inheritedReadConcern = inheritedReadConcern;
        }

        public boolean isImplicitSession() {
            return this.ownsSession;
        }

        public boolean notifyMessageSent() {
            return this.clientSession.notifyMessageSent();
        }

        public boolean isSnapshot() {
            Boolean snapshot = this.clientSession.getOptions().isSnapshot();
            return snapshot != null && snapshot != false;
        }

        public void setSnapshotTimestamp(@Nullable BsonTimestamp snapshotTimestamp) {
            this.clientSession.setSnapshotTimestamp(snapshotTimestamp);
        }

        @Nullable
        public BsonTimestamp getSnapshotTimestamp() {
            return this.clientSession.getSnapshotTimestamp();
        }

        public boolean hasActiveTransaction() {
            return this.clientSession.hasActiveTransaction();
        }

        public ReadConcern getReadConcern() {
            if (this.clientSession.hasActiveTransaction()) {
                return (ReadConcern)Assertions.assertNotNull((Object)this.clientSession.getTransactionOptions().getReadConcern());
            }
            if (this.isSnapshot()) {
                return ReadConcern.SNAPSHOT;
            }
            return this.inheritedReadConcern;
        }
    }

    private class SessionBindingAsyncConnectionSource
    implements AsyncConnectionSource {
        private AsyncConnectionSource wrapped;

        SessionBindingAsyncConnectionSource(AsyncConnectionSource wrapped) {
            this.wrapped = wrapped;
            ClientSessionBinding.this.retain();
        }

        public ServerDescription getServerDescription() {
            return this.wrapped.getServerDescription();
        }

        public ReadPreference getReadPreference() {
            return this.wrapped.getReadPreference();
        }

        public void getConnection(OperationContext operationContext, SingleResultCallback<AsyncConnection> callback) {
            TransactionContext transactionContext = TransactionContext.get((com.mongodb.session.ClientSession)ClientSessionBinding.this.session);
            if (transactionContext != null && transactionContext.isConnectionPinningRequired()) {
                AsyncConnection pinnedConnection = (AsyncConnection)transactionContext.getPinnedConnection();
                if (pinnedConnection == null) {
                    this.wrapped.getConnection(operationContext, (connection, t) -> {
                        if (t != null) {
                            callback.onResult(null, t);
                        } else {
                            transactionContext.pinConnection((ReferenceCounted)((AsyncConnection)Assertions.assertNotNull((Object)connection)), AsyncConnection::markAsPinned);
                            callback.onResult(connection, null);
                        }
                    });
                } else {
                    callback.onResult((Object)pinnedConnection.retain(), null);
                }
            } else {
                this.wrapped.getConnection(operationContext, callback);
            }
        }

        public AsyncConnectionSource retain() {
            this.wrapped = this.wrapped.retain();
            return this;
        }

        public int getCount() {
            return this.wrapped.getCount();
        }

        public int release() {
            int count = this.wrapped.release();
            if (count == 0) {
                ClientSessionBinding.this.release();
            }
            return count;
        }
    }
}

