/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client;

import com.mongodb.ClientSessionOptions;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.annotations.Alpha;
import com.mongodb.annotations.Immutable;
import com.mongodb.annotations.Reason;
import com.mongodb.lang.Nullable;
import com.mongodb.reactivestreams.client.ChangeStreamPublisher;
import com.mongodb.reactivestreams.client.ClientSession;
import com.mongodb.reactivestreams.client.ListDatabasesPublisher;
import com.mongodb.reactivestreams.client.MongoDatabase;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.reactivestreams.Publisher;

@Immutable
public interface MongoCluster {
    public CodecRegistry getCodecRegistry();

    public ReadPreference getReadPreference();

    public WriteConcern getWriteConcern();

    public ReadConcern getReadConcern();

    @Nullable
    @Alpha(value={Reason.CLIENT})
    public Long getTimeout(TimeUnit var1);

    public MongoCluster withCodecRegistry(CodecRegistry var1);

    public MongoCluster withReadPreference(ReadPreference var1);

    public MongoCluster withWriteConcern(WriteConcern var1);

    public MongoCluster withReadConcern(ReadConcern var1);

    @Alpha(value={Reason.CLIENT})
    public MongoCluster withTimeout(long var1, TimeUnit var3);

    public MongoDatabase getDatabase(String var1);

    public Publisher<ClientSession> startSession();

    public Publisher<ClientSession> startSession(ClientSessionOptions var1);

    public Publisher<String> listDatabaseNames();

    public Publisher<String> listDatabaseNames(ClientSession var1);

    public ListDatabasesPublisher<Document> listDatabases();

    public ListDatabasesPublisher<Document> listDatabases(ClientSession var1);

    public <TResult> ListDatabasesPublisher<TResult> listDatabases(Class<TResult> var1);

    public <TResult> ListDatabasesPublisher<TResult> listDatabases(ClientSession var1, Class<TResult> var2);

    public ChangeStreamPublisher<Document> watch();

    public <TResult> ChangeStreamPublisher<TResult> watch(Class<TResult> var1);

    public ChangeStreamPublisher<Document> watch(List<? extends Bson> var1);

    public <TResult> ChangeStreamPublisher<TResult> watch(List<? extends Bson> var1, Class<TResult> var2);

    public ChangeStreamPublisher<Document> watch(ClientSession var1);

    public <TResult> ChangeStreamPublisher<TResult> watch(ClientSession var1, Class<TResult> var2);

    public ChangeStreamPublisher<Document> watch(ClientSession var1, List<? extends Bson> var2);

    public <TResult> ChangeStreamPublisher<TResult> watch(ClientSession var1, List<? extends Bson> var2, Class<TResult> var3);
}

