/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.internal;

import com.mongodb.MongoNamespace;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.CreateCollectionOptions;
import com.mongodb.client.model.CreateViewOptions;
import com.mongodb.internal.client.model.AggregationLevel;
import com.mongodb.internal.client.model.changestream.ChangeStreamLevel;
import com.mongodb.reactivestreams.client.AggregatePublisher;
import com.mongodb.reactivestreams.client.ChangeStreamPublisher;
import com.mongodb.reactivestreams.client.ClientSession;
import com.mongodb.reactivestreams.client.ListCollectionsPublisher;
import com.mongodb.reactivestreams.client.MongoCollection;
import com.mongodb.reactivestreams.client.MongoDatabase;
import com.mongodb.reactivestreams.client.internal.AggregatePublisherImpl;
import com.mongodb.reactivestreams.client.internal.ChangeStreamPublisherImpl;
import com.mongodb.reactivestreams.client.internal.ListCollectionsPublisherImpl;
import com.mongodb.reactivestreams.client.internal.MongoCollectionImpl;
import com.mongodb.reactivestreams.client.internal.MongoOperationPublisher;
import java.util.Collections;
import java.util.List;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public final class MongoDatabaseImpl
implements MongoDatabase {
    private final MongoOperationPublisher<Document> mongoOperationPublisher;

    MongoDatabaseImpl(MongoOperationPublisher<Document> mongoOperationPublisher) {
        this.mongoOperationPublisher = (MongoOperationPublisher)Assertions.notNull((String)"publisherHelper", mongoOperationPublisher);
        MongoNamespace.checkDatabaseNameValidity((String)this.getName());
    }

    @Override
    public String getName() {
        return ((MongoNamespace)Assertions.assertNotNull((Object)this.mongoOperationPublisher.getNamespace())).getDatabaseName();
    }

    @Override
    public CodecRegistry getCodecRegistry() {
        return this.mongoOperationPublisher.getCodecRegistry();
    }

    @Override
    public ReadPreference getReadPreference() {
        return this.mongoOperationPublisher.getReadPreference();
    }

    @Override
    public WriteConcern getWriteConcern() {
        return this.mongoOperationPublisher.getWriteConcern();
    }

    @Override
    public ReadConcern getReadConcern() {
        return this.mongoOperationPublisher.getReadConcern();
    }

    MongoOperationPublisher<Document> getMongoOperationPublisher() {
        return this.mongoOperationPublisher;
    }

    @Override
    public MongoDatabase withCodecRegistry(CodecRegistry codecRegistry) {
        return new MongoDatabaseImpl(this.mongoOperationPublisher.withCodecRegistry(codecRegistry));
    }

    @Override
    public MongoDatabase withReadPreference(ReadPreference readPreference) {
        return new MongoDatabaseImpl(this.mongoOperationPublisher.withReadPreference(readPreference));
    }

    @Override
    public MongoDatabase withWriteConcern(WriteConcern writeConcern) {
        return new MongoDatabaseImpl(this.mongoOperationPublisher.withWriteConcern(writeConcern));
    }

    @Override
    public MongoDatabase withReadConcern(ReadConcern readConcern) {
        return new MongoDatabaseImpl(this.mongoOperationPublisher.withReadConcern(readConcern));
    }

    @Override
    public MongoCollection<Document> getCollection(String collectionName) {
        return this.getCollection(collectionName, (Class<T>)Document.class);
    }

    public <T> MongoCollection<T> getCollection(String collectionName, Class<T> clazz) {
        return new MongoCollectionImpl<T>(this.mongoOperationPublisher.withNamespaceAndDocumentClass(new MongoNamespace(this.getName(), collectionName), clazz));
    }

    @Override
    public Publisher<Document> runCommand(Bson command) {
        return this.runCommand(command, (Class<T>)Document.class);
    }

    @Override
    public Publisher<Document> runCommand(Bson command, ReadPreference readPreference) {
        return this.runCommand(command, readPreference, (Class<T>)Document.class);
    }

    public <T> Publisher<T> runCommand(Bson command, Class<T> clazz) {
        return this.runCommand(command, ReadPreference.primary(), clazz);
    }

    public <T> Publisher<T> runCommand(Bson command, ReadPreference readPreference, Class<T> clazz) {
        return this.mongoOperationPublisher.runCommand(null, command, readPreference, clazz);
    }

    @Override
    public Publisher<Document> runCommand(ClientSession clientSession, Bson command) {
        return this.runCommand(clientSession, command, (Class<T>)Document.class);
    }

    @Override
    public Publisher<Document> runCommand(ClientSession clientSession, Bson command, ReadPreference readPreference) {
        return this.runCommand(clientSession, command, readPreference, (Class<T>)Document.class);
    }

    public <T> Publisher<T> runCommand(ClientSession clientSession, Bson command, Class<T> clazz) {
        return this.runCommand(clientSession, command, ReadPreference.primary(), clazz);
    }

    public <T> Publisher<T> runCommand(ClientSession clientSession, Bson command, ReadPreference readPreference, Class<T> clazz) {
        return this.mongoOperationPublisher.runCommand((ClientSession)Assertions.notNull((String)"clientSession", (Object)clientSession), command, readPreference, clazz);
    }

    @Override
    public Publisher<Void> drop() {
        return this.mongoOperationPublisher.dropDatabase(null);
    }

    @Override
    public Publisher<Void> drop(ClientSession clientSession) {
        return this.mongoOperationPublisher.dropDatabase((ClientSession)Assertions.notNull((String)"clientSession", (Object)clientSession));
    }

    @Override
    public Publisher<String> listCollectionNames() {
        return Flux.from(new ListCollectionsPublisherImpl<Document>(null, this.mongoOperationPublisher, true)).map(d -> d.getString((Object)"name"));
    }

    @Override
    public Publisher<String> listCollectionNames(ClientSession clientSession) {
        return Flux.from(new ListCollectionsPublisherImpl<Document>((ClientSession)Assertions.notNull((String)"clientSession", (Object)clientSession), this.mongoOperationPublisher, true)).map(d -> d.getString((Object)"name"));
    }

    @Override
    public ListCollectionsPublisher<Document> listCollections() {
        return this.listCollections((Class)Document.class);
    }

    public <C> ListCollectionsPublisher<C> listCollections(Class<C> clazz) {
        return new ListCollectionsPublisherImpl<C>(null, this.mongoOperationPublisher.withDocumentClass(clazz), false);
    }

    @Override
    public ListCollectionsPublisher<Document> listCollections(ClientSession clientSession) {
        return this.listCollections(clientSession, (Class)Document.class);
    }

    public <C> ListCollectionsPublisher<C> listCollections(ClientSession clientSession, Class<C> clazz) {
        return new ListCollectionsPublisherImpl<C>((ClientSession)Assertions.notNull((String)"clientSession", (Object)clientSession), this.mongoOperationPublisher.withDocumentClass(clazz), false);
    }

    @Override
    public Publisher<Void> createCollection(String collectionName) {
        return this.createCollection(collectionName, new CreateCollectionOptions());
    }

    @Override
    public Publisher<Void> createCollection(String collectionName, CreateCollectionOptions options) {
        return this.mongoOperationPublisher.createCollection(null, (String)Assertions.notNull((String)"collectionName", (Object)collectionName), (CreateCollectionOptions)Assertions.notNull((String)"options", (Object)options));
    }

    @Override
    public Publisher<Void> createCollection(ClientSession clientSession, String collectionName) {
        return this.createCollection(clientSession, collectionName, new CreateCollectionOptions());
    }

    @Override
    public Publisher<Void> createCollection(ClientSession clientSession, String collectionName, CreateCollectionOptions options) {
        return this.mongoOperationPublisher.createCollection((ClientSession)Assertions.notNull((String)"clientSession", (Object)clientSession), (String)Assertions.notNull((String)"collectionName", (Object)collectionName), (CreateCollectionOptions)Assertions.notNull((String)"options", (Object)options));
    }

    @Override
    public Publisher<Void> createView(String viewName, String viewOn, List<? extends Bson> pipeline) {
        return this.createView(viewName, viewOn, pipeline, new CreateViewOptions());
    }

    @Override
    public Publisher<Void> createView(String viewName, String viewOn, List<? extends Bson> pipeline, CreateViewOptions options) {
        return this.mongoOperationPublisher.createView(null, viewName, viewOn, pipeline, options);
    }

    @Override
    public Publisher<Void> createView(ClientSession clientSession, String viewName, String viewOn, List<? extends Bson> pipeline) {
        return this.createView(clientSession, viewName, viewOn, pipeline, new CreateViewOptions());
    }

    @Override
    public Publisher<Void> createView(ClientSession clientSession, String viewName, String viewOn, List<? extends Bson> pipeline, CreateViewOptions options) {
        return this.mongoOperationPublisher.createView((ClientSession)Assertions.notNull((String)"clientSession", (Object)clientSession), viewName, viewOn, pipeline, options);
    }

    @Override
    public ChangeStreamPublisher<Document> watch() {
        return this.watch(Collections.emptyList());
    }

    public <T> ChangeStreamPublisher<T> watch(Class<T> resultClass) {
        return this.watch((List<? extends Bson>)Collections.emptyList(), resultClass);
    }

    @Override
    public ChangeStreamPublisher<Document> watch(List<? extends Bson> pipeline) {
        return this.watch(pipeline, (Class<T>)Document.class);
    }

    public <T> ChangeStreamPublisher<T> watch(List<? extends Bson> pipeline, Class<T> resultClass) {
        return new ChangeStreamPublisherImpl<T>(null, this.mongoOperationPublisher, resultClass, pipeline, ChangeStreamLevel.DATABASE);
    }

    @Override
    public ChangeStreamPublisher<Document> watch(ClientSession clientSession) {
        return this.watch(clientSession, (List<? extends Bson>)Collections.emptyList(), (Class<T>)Document.class);
    }

    public <T> ChangeStreamPublisher<T> watch(ClientSession clientSession, Class<T> resultClass) {
        return this.watch(clientSession, (List<? extends Bson>)Collections.emptyList(), resultClass);
    }

    @Override
    public ChangeStreamPublisher<Document> watch(ClientSession clientSession, List<? extends Bson> pipeline) {
        return this.watch(clientSession, pipeline, (Class<T>)Document.class);
    }

    public <T> ChangeStreamPublisher<T> watch(ClientSession clientSession, List<? extends Bson> pipeline, Class<T> resultClass) {
        return new ChangeStreamPublisherImpl<T>((ClientSession)Assertions.notNull((String)"clientSession", (Object)clientSession), this.mongoOperationPublisher, resultClass, pipeline, ChangeStreamLevel.DATABASE);
    }

    @Override
    public AggregatePublisher<Document> aggregate(List<? extends Bson> pipeline) {
        return this.aggregate(pipeline, (Class<T>)Document.class);
    }

    public <T> AggregatePublisher<T> aggregate(List<? extends Bson> pipeline, Class<T> resultClass) {
        return new AggregatePublisherImpl<T>(null, this.mongoOperationPublisher.withDocumentClass(resultClass), pipeline, AggregationLevel.DATABASE);
    }

    @Override
    public AggregatePublisher<Document> aggregate(ClientSession clientSession, List<? extends Bson> pipeline) {
        return this.aggregate(clientSession, pipeline, (Class<T>)Document.class);
    }

    public <T> AggregatePublisher<T> aggregate(ClientSession clientSession, List<? extends Bson> pipeline, Class<T> resultClass) {
        return new AggregatePublisherImpl<T>((ClientSession)Assertions.notNull((String)"clientSession", (Object)clientSession), this.mongoOperationPublisher.withDocumentClass(resultClass), pipeline, AggregationLevel.DATABASE);
    }
}

