/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.internal;

import com.mongodb.MongoException;
import com.mongodb.internal.async.AsyncBatchCursor;
import com.mongodb.internal.async.client.AsyncMongoIterable;
import com.mongodb.reactivestreams.client.internal.AbstractSubscription;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class MongoIterableSubscription<TResult>
extends AbstractSubscription<TResult> {
    private final AsyncMongoIterable<TResult> mongoIterable;
    private boolean isReading;
    private boolean completed;
    private volatile AsyncBatchCursor<TResult> batchCursor;

    MongoIterableSubscription(AsyncMongoIterable<TResult> mongoIterable, Subscriber<? super TResult> subscriber) {
        super(subscriber);
        this.mongoIterable = mongoIterable;
        subscriber.onSubscribe((Subscription)this);
    }

    @Override
    void requestInitialData() {
        this.mongoIterable.batchSize(this.calculateBatchSize());
        this.mongoIterable.batchCursor((result, t) -> {
            if (t != null) {
                this.onError(t);
            } else if (result != null) {
                this.batchCursor = result;
                this.requestMoreData();
            } else {
                this.onError((Throwable)new MongoException("Unexpected error, no AsyncBatchCursor returned from the MongoIterable."));
            }
        });
    }

    @Override
    boolean checkCompleted() {
        return this.completed;
    }

    @Override
    void postTerminate() {
        try {
            if (this.batchCursor != null) {
                this.batchCursor.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void requestMoreData() {
        boolean mustRead = false;
        MongoIterableSubscription mongoIterableSubscription = this;
        synchronized (mongoIterableSubscription) {
            if (!(this.isReading || this.isTerminated() || this.batchCursor == null || this.batchCursor.isClosed())) {
                this.isReading = true;
                mustRead = true;
            }
        }
        if (mustRead) {
            this.batchCursor.setBatchSize(this.calculateBatchSize());
            this.batchCursor.next((result, t) -> {
                MongoIterableSubscription mongoIterableSubscription = this;
                synchronized (mongoIterableSubscription) {
                    this.isReading = false;
                }
                if (t != null) {
                    this.onError(t);
                } else {
                    this.addToQueue(result);
                    mongoIterableSubscription = this;
                    synchronized (mongoIterableSubscription) {
                        if (result == null) {
                            this.completed = true;
                        }
                    }
                    this.tryProcessResultsQueue();
                }
            });
        }
    }

    private int calculateBatchSize() {
        Integer batchSize = this.mongoIterable.getBatchSize();
        if (batchSize != null) {
            return batchSize;
        }
        long requested = this.getRequested();
        if (requested <= 1L) {
            return 2;
        }
        if (requested < Integer.MAX_VALUE) {
            return (int)requested;
        }
        return Integer.MAX_VALUE;
    }
}

