/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.vault;

import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.vault.DataKeyOptions;
import com.mongodb.client.model.vault.EncryptOptions;
import com.mongodb.internal.async.client.vault.AsyncClientEncryption;
import com.mongodb.reactivestreams.client.internal.Publishers;
import com.mongodb.reactivestreams.client.vault.ClientEncryption;
import org.bson.BsonBinary;
import org.bson.BsonValue;
import org.reactivestreams.Publisher;

class ClientEncryptionImpl
implements ClientEncryption {
    private final AsyncClientEncryption wrapped;

    ClientEncryptionImpl(AsyncClientEncryption wrapped) {
        this.wrapped = (AsyncClientEncryption)Assertions.notNull((String)"wrapped", (Object)wrapped);
    }

    @Override
    public Publisher<BsonBinary> createDataKey(String kmsProvider) {
        return this.createDataKey(kmsProvider, new DataKeyOptions());
    }

    @Override
    public Publisher<BsonBinary> createDataKey(String kmsProvider, DataKeyOptions dataKeyOptions) {
        return Publishers.publish(callback -> this.wrapped.createDataKey(kmsProvider, dataKeyOptions, callback));
    }

    @Override
    public Publisher<BsonBinary> encrypt(BsonValue value, EncryptOptions options) {
        return Publishers.publish(callback -> this.wrapped.encrypt(value, options, callback));
    }

    @Override
    public Publisher<BsonValue> decrypt(BsonBinary value) {
        return Publishers.publish(callback -> this.wrapped.decrypt(value, callback));
    }

    @Override
    public void close() {
        this.wrapped.close();
    }
}

