/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.internal;

import com.mongodb.Block;
import com.mongodb.ClientSessionOptions;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.MongoClientSettings;
import com.mongodb.async.client.MongoIterable;
import com.mongodb.async.client.Observables;
import com.mongodb.reactivestreams.client.ListDatabasesPublisher;
import com.mongodb.reactivestreams.client.MongoClient;
import com.mongodb.reactivestreams.client.MongoDatabase;
import com.mongodb.reactivestreams.client.internal.ListDatabasesPublisherImpl;
import com.mongodb.reactivestreams.client.internal.MongoDatabaseImpl;
import com.mongodb.reactivestreams.client.internal.ObservableToPublisher;
import com.mongodb.session.ClientSession;
import org.bson.Document;
import org.reactivestreams.Publisher;

public final class MongoClientImpl
implements MongoClient {
    private final com.mongodb.async.client.MongoClient wrapped;

    public MongoClientImpl(com.mongodb.async.client.MongoClient wrapped) {
        this.wrapped = (com.mongodb.async.client.MongoClient)Assertions.notNull((String)"wrapped", (Object)wrapped);
    }

    @Override
    public MongoDatabase getDatabase(String name) {
        return new MongoDatabaseImpl(this.wrapped.getDatabase(name));
    }

    @Override
    public void close() {
        this.wrapped.close();
    }

    @Override
    @Deprecated
    public MongoClientSettings getSettings() {
        return this.wrapped.getSettings();
    }

    @Override
    public Publisher<String> listDatabaseNames() {
        return new ObservableToPublisher<String>(Observables.observe((MongoIterable)this.wrapped.listDatabaseNames()));
    }

    @Override
    public Publisher<String> listDatabaseNames(ClientSession clientSession) {
        return new ObservableToPublisher<String>(Observables.observe((MongoIterable)this.wrapped.listDatabaseNames(clientSession)));
    }

    @Override
    public ListDatabasesPublisher<Document> listDatabases() {
        return this.listDatabases(Document.class);
    }

    @Override
    public <TResult> ListDatabasesPublisher<TResult> listDatabases(Class<TResult> clazz) {
        return new ListDatabasesPublisherImpl(this.wrapped.listDatabases(clazz));
    }

    @Override
    public ListDatabasesPublisher<Document> listDatabases(ClientSession clientSession) {
        return this.listDatabases(clientSession, Document.class);
    }

    @Override
    public <TResult> ListDatabasesPublisher<TResult> listDatabases(ClientSession clientSession, Class<TResult> clazz) {
        return new ListDatabasesPublisherImpl(this.wrapped.listDatabases(clientSession, clazz));
    }

    @Override
    public Publisher<ClientSession> startSession(final ClientSessionOptions options) {
        return new ObservableToPublisher<ClientSession>(Observables.observe((Block)new Block<SingleResultCallback<ClientSession>>(){

            public void apply(SingleResultCallback<ClientSession> clientSessionSingleResultCallback) {
                MongoClientImpl.this.wrapped.startSession(options, clientSessionSingleResultCallback);
            }
        }));
    }
}

